/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.inventory.ISidedHopper;

public class SidedHopperConfig {
    private final Transfer[] transfers = new Transfer[6];
    private final ISidedHopper hopper;

    public SidedHopperConfig(ISidedHopper hopper) {
        this.hopper = hopper;
        Arrays.fill((Object[])this.transfers, (Object)Transfer.NONE);
    }

    public void read(CompoundNBT nbt) {
        if (nbt.func_150297_b("hopper_transfer_type", 11)) {
            int[] arr = nbt.func_74759_k("hopper_transfer_type");
            for (int i = 0; i < arr.length; ++i) {
                this.setType(Direction.func_82600_a((int)i), Transfer.values()[arr[i]]);
            }
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int valuesLength = this.transfers.length;
        for (int i = 0; i < valuesLength; ++i) {
            list.add(i, this.transfers[i].ordinal());
        }
        nbt.func_197646_b("hopper_transfer_type", list);
        return nbt;
    }

    public void nextTypeAll() {
        if (this.isAllEquals()) {
            for (Direction side : Direction.values()) {
                this.nextType(side);
            }
        } else {
            for (Direction side : Direction.values()) {
                this.setType(side, Transfer.ALL);
            }
        }
    }

    public boolean isAllEquals() {
        int first = this.transfers[0].ordinal();
        for (int i = 1; i < 6; ++i) {
            if (this.transfers[i].ordinal() == first) continue;
            return false;
        }
        return true;
    }

    public void nextType(@Nullable Direction side) {
        this.setType(side, this.getType(side).next(this.hopper.getItemTransfer()));
    }

    public Transfer getType(@Nullable Direction side) {
        if (side != null) {
            return this.transfers[side.func_176745_a()];
        }
        return Transfer.NONE;
    }

    public void setType(@Nullable Direction side, Transfer type) {
        if (side == null || this.hopper.getItemTransfer().equals((Object)Transfer.NONE)) {
            return;
        }
        this.transfers[side.func_176745_a()] = type;
        this.hopper.getSidedHopper().setPush(side, type.canExtract);
        this.hopper.getSidedHopper().setPull(side, type.canReceive);
    }
}

