/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics.inventory;

import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import owmii.lib.logistics.inventory.Inventory;
import owmii.lib.util.Util;

public class Hopper {
    private final Inventory inv;
    private boolean push;
    private boolean pull;

    public Hopper(Inventory inv) {
        this.inv = inv;
    }

    public void read(CompoundNBT nbt, String key) {
        this.push = nbt.func_74767_n("push_" + key);
        this.pull = nbt.func_74767_n("pull_" + key);
    }

    public CompoundNBT write(CompoundNBT nbt, String key) {
        nbt.func_74757_a("push_" + key, this.push);
        nbt.func_74757_a("pull_" + key, this.pull);
        return nbt;
    }

    public void transfer(IItemHandler to, int max, Predicate<ItemStack> pull, Predicate<ItemStack> push, int ... ex) {
        this.pull(to, max, pull, ex);
        this.push(to, max, push, ex);
    }

    protected void push(IItemHandler to, int max, Predicate<ItemStack> predicate, int ... ex) {
        if (this.push) {
            for (int i = 0; i < this.inv.getSlots(); ++i) {
                ItemStack insert;
                ItemStack stack;
                if (Util.anyMatch(ex, i) || (stack = this.inv.extractItem(i, max, true)).func_190926_b() || !predicate.test(stack) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(insert = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)stack.func_77946_l(), (boolean)false)))) continue;
                this.inv.extractItem(i, stack.func_190916_E() - insert.func_190916_E(), false);
                break;
            }
        }
    }

    protected void pull(IItemHandler from, int max, Predicate<ItemStack> predicate, int ... ex) {
        if (this.pull) {
            for (int i = 0; i < from.getSlots(); ++i) {
                ItemStack insert;
                ItemStack stack;
                if (Util.anyMatch(ex, i) || (stack = from.extractItem(i, max, true)).func_190926_b() || !predicate.test(stack) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(insert = this.inv.insertItem(stack.func_77946_l(), false, ex)))) continue;
                from.extractItem(i, stack.func_190916_E() - insert.func_190916_E(), false);
                break;
            }
        }
    }

    public void switchPull() {
        this.setPull(!this.canPull());
    }

    public void switchPush() {
        this.setPush(!this.canPush());
    }

    public boolean canPull() {
        return this.pull;
    }

    public Hopper setPull(boolean pull) {
        this.pull = pull;
        return this;
    }

    public boolean canPush() {
        return this.push;
    }

    public Hopper setPush(boolean push) {
        this.push = push;
        return this;
    }

    public boolean isActive() {
        return this.push || this.pull;
    }
}

