/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.wiki.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import owmii.lib.client.screen.Texture;
import owmii.lib.client.screen.wiki.WikiScreen;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.Entry;
import owmii.lib.client.wiki.Page;
import owmii.lib.client.wiki.Section;

public class Info
extends Page {
    private final List<ITextComponent> cache = new ArrayList<ITextComponent>();
    private final Texture img;
    private final int paragraphs;
    private final Object[][] args;

    public Info(String name, Object[][] args, Section parent) {
        this(name, 1, args, parent);
    }

    public Info(String name, Section parent) {
        this(name, 1, parent);
    }

    public Info(String name, int paragraphs, Object[][] args, Section parent) {
        this(name, Texture.EMPTY, paragraphs, args, parent);
    }

    public Info(String name, int paragraphs, Section parent) {
        this(name, Texture.EMPTY, paragraphs, parent);
    }

    public Info(int paragraphs, Object[][] args, Section parent) {
        this(Texture.EMPTY, paragraphs, args, parent);
    }

    public Info(Section parent) {
        this(Texture.EMPTY, 1, parent);
    }

    public Info(int paragraphs, Section parent) {
        this(Texture.EMPTY, paragraphs, parent);
    }

    public Info(Texture img, Object[][] args, Section parent) {
        this(img, 1, args, parent);
    }

    public Info(Texture img, Section parent) {
        this(img, 1, parent);
    }

    public Info(Texture img, int paragraphs, Object[][] args, Section parent) {
        this(parent.getEntry().getTransKey(), img, paragraphs, args, parent);
    }

    public Info(Texture img, int paragraphs, Section parent) {
        this(parent.getEntry().getTransKey(), img, paragraphs, parent);
    }

    public Info(String name, Texture img, int paragraphs, Section parent) {
        this(name, img, paragraphs, new Object[paragraphs][0], parent);
    }

    public Info(String name, Texture img, int paragraphs, Object[][] args, Section parent) {
        super(name, parent);
        this.img = img;
        this.paragraphs = paragraphs;
        this.args = args;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init(int x, int y, WikiScreen screen) {
        super.init(x, y, screen);
        this.cache.clear();
        int pp = 0;
        Page page = this;
        while (page != null && page.prev() != null) {
            Page prev = page.prev();
            if (prev instanceof Info) {
                pp += ((Info)prev).paragraphs;
            }
            page = prev;
        }
        Entry e = this.getSection().getEntry();
        for (int i = 0; i < this.paragraphs; ++i) {
            TranslationTextComponent text = new TranslationTextComponent("wiki." + e.getWiki().getModId() + "." + e.getName() + "_" + (i + pp), this.args[i]);
            TranslationTextComponent ft = new TranslationTextComponent("");
            String[] words = text.getString().split("\\s+");
            for (int j = 0; j < words.length; ++j) {
                String w = words[j];
                if (w.startsWith("<") && w.contains(":") && w.endsWith(">")) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(w.substring(1, w.length() - 1)));
                    ft = ft.func_230529_a_((ITextComponent)new ItemStack((IItemProvider)item).func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.BLUE)).func_240702_b_(" ");
                    continue;
                }
                ft = ft.func_240702_b_(w).func_240702_b_(" ");
            }
            ft.func_240703_c_(Text.color(2045759));
            this.cache.add((ITextComponent)ft);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, int x, int y, int mx, int my, float pt, FontRenderer font, WikiScreen screen) {
        if (!this.img.isEmpty()) {
            this.img.draw(matrix, x + 3, y + 3);
            y += this.img.getHeight() + 2;
        }
        for (int i = 0; i < this.cache.size(); ++i) {
            ITextComponent text = this.cache.get(i);
            Text.drawString((ITextProperties)text, x + 6, y + 7, screen.w / 2 - 5, 10, 3687740);
            y += (i + 1 == this.cache.size() ? 0 : 3) + font.func_238425_b_((ITextProperties)text, screen.w / 2 - 5).size() * 10;
        }
    }
}

