/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.client.util.Text;
import owmii.lib.client.wiki.page.panel.InfoBox;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.logistics.Transfer;
import owmii.lib.logistics.energy.Energy;
import owmii.lib.util.Util;

public abstract class AbstractGeneratorBlock<V extends Enum<V>, C extends IEnergyConfig<V>, B extends AbstractGeneratorBlock<V, C, B>>
extends AbstractEnergyBlock<V, C, B> {
    public AbstractGeneratorBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public AbstractGeneratorBlock(AbstractBlock.Properties properties, V variant) {
        super(properties, variant);
    }

    @Override
    public void additionalEnergyInfo(ItemStack stack, Energy.Item energy, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("info.lollipop.generates").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)Text.COLON).func_230529_a_((ITextComponent)new StringTextComponent(Util.numFormat(((IEnergyConfig)this.getConfig()).getGeneration((Enum)((Object)this.variant)))).func_230529_a_((ITextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick")).func_240699_a_(TextFormatting.DARK_GRAY)));
    }

    @Override
    public Transfer getTransferType() {
        return Transfer.EXTRACT;
    }

    @Override
    public InfoBox getInfoBox(ItemStack stack, InfoBox box) {
        Energy.ifPresent(stack, (NonNullConsumer<? super IEnergyStorage>)((NonNullConsumer)storage -> {
            if (storage instanceof Energy.Item) {
                Energy.Item energy = (Energy.Item)storage;
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.capacity"), (TextComponent)new TranslationTextComponent("info.lollipop.fe", new Object[]{Util.addCommas(energy.getCapacity())}));
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.generates"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(((IEnergyConfig)this.getConfig()).getGeneration((Enum)((Object)this.variant)))}));
                box.set((TextComponent)new TranslationTextComponent("info.lollipop.max.extract"), (TextComponent)new TranslationTextComponent("info.lollipop.fe.pet.tick", new Object[]{Util.addCommas(energy.getMaxExtract())}));
            }
        }));
        return box;
    }
}

