/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.api;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import owmii.lib.api.IClient;

public interface IMod {
    default public void setup(FMLCommonSetupEvent event) {
    }

    default public void modEnqueue(InterModEnqueueEvent event) {
    }

    default public void loadComplete(FMLLoadCompleteEvent event) {
    }

    default public void aboutToStar(FMLServerAboutToStartEvent event) {
    }

    default public void starting(FMLServerStartingEvent event) {
    }

    default public void started(FMLServerStartedEvent event) {
    }

    default public void stopped(FMLServerStoppedEvent event) {
    }

    default public <T extends Event> void addModListener(Consumer<T> consumer) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(consumer);
    }

    default public <T extends Event> void addEventListener(Consumer<T> consumer) {
        MinecraftForge.EVENT_BUS.addListener(consumer);
    }

    default public void loadListeners() {
        this.addModListener(this::setup);
        this.addModListener(this::modEnqueue);
        this.addModListener(this::loadComplete);
        this.addEventListener(this::aboutToStar);
        this.addEventListener(this::starting);
        this.addEventListener(this::started);
        this.addEventListener(this::stopped);
        IClient mod = this.getClient();
        if (mod != null) {
            this.addModListener(mod::client);
            this.addModListener(event -> event.enqueueWork(() -> mod.syncClient((FMLClientSetupEvent)event)));
        }
    }

    @Nullable
    public IClient getClient();
}

