/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.container;

import com.tfar.metalbarrels.MetalBarrels;
import com.tfar.metalbarrels.tile.MetalBarrelBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MetalBarrelContainer
extends Container {
    protected PlayerEntity playerEntity;
    private final IWorldPosCallable callable;
    public int width;
    public int height;

    public MetalBarrelContainer(ContainerType<?> containerType, int id, PlayerInventory playerInventory, int width, int height, int containerX, int containerY, int playerX, int playerY) {
        this(containerType, id, playerInventory, width, height, containerX, containerY, playerY, playerX, IWorldPosCallable.field_221489_a);
    }

    public MetalBarrelContainer(ContainerType<?> containerType, int id, PlayerInventory playerInventory, int width, int height, int containerX, int containerY, int playerY, int playerX, IWorldPosCallable callable) {
        super(containerType, id);
        int j;
        int i;
        this.width = width;
        this.height = height;
        this.playerEntity = playerInventory.field_70458_d;
        this.callable = callable;
        ItemStackHandler stackHandler = callable.func_221484_a(World::func_175625_s).map(MetalBarrelBlockEntity.class::cast).map(metalBarrelBlockEntity -> metalBarrelBlockEntity.handler).orElse(new ItemStackHandler(width * height));
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)stackHandler, j + width * i, containerX + j * 18, containerY + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, j * 18 + playerX, i * 18 + playerY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, i * 18 + playerX, playerY + 58));
        }
    }

    public static MetalBarrelContainer copper(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.COPPER_CONTAINER, id, playerInventory, 9, 5, 8, 18, 8, 122);
    }

    public static MetalBarrelContainer iron(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.IRON_CONTAINER, id, playerInventory, 9, 6, 8, 18, 8, 140);
    }

    public static MetalBarrelContainer silver(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.SILVER_CONTAINER, id, playerInventory, 9, 8, 8, 18, 8, 176);
    }

    public static MetalBarrelContainer gold(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.GOLD_CONTAINER, id, playerInventory, 9, 9, 8, 18, 8, 194);
    }

    public static MetalBarrelContainer diamond(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.DIAMOND_CONTAINER, id, playerInventory, 12, 9, 8, 18, 35, 194);
    }

    public static MetalBarrelContainer netherite(int id, PlayerInventory playerInventory) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.NETHERITE_CONTAINER, id, playerInventory, 15, 9, 8, 18, 62, 194);
    }

    public static MetalBarrelContainer copperS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.COPPER_CONTAINER, id, playerInventory, 9, 5, 8, 18, 8, 122, callable);
    }

    public static MetalBarrelContainer ironS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.IRON_CONTAINER, id, playerInventory, 9, 6, 8, 18, 8, 140, callable);
    }

    public static MetalBarrelContainer silverS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.SILVER_CONTAINER, id, playerInventory, 9, 8, 8, 18, 8, 176, callable);
    }

    public static MetalBarrelContainer goldS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.GOLD_CONTAINER, id, playerInventory, 9, 9, 8, 18, 8, 194, callable);
    }

    public static MetalBarrelContainer diamondS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.DIAMOND_CONTAINER, id, playerInventory, 12, 9, 8, 18, 35, 194, callable);
    }

    public static MetalBarrelContainer netheriteS(int id, PlayerInventory playerInventory, IWorldPosCallable callable) {
        return new MetalBarrelContainer(MetalBarrels.ObjectHolders.NETHERITE_CONTAINER, id, playerInventory, 15, 9, 8, 18, 62, 194, callable);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.height * this.width ? !this.func_75135_a(itemstack1, this.height * this.width, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.height * this.width, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.callable.func_221486_a((world, pos) -> {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null) {
                MetalBarrels.logger.warn("unexpected null on container close");
                return;
            }
            MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)tileEntity;
            if (!playerIn.func_175149_v()) {
                --metalBarrelBlockEntity.players;
            }
            if (metalBarrelBlockEntity.players <= 0) {
                metalBarrelBlockEntity.soundStuff(tileEntity.func_195044_w(), SoundEvents.field_219601_N);
                metalBarrelBlockEntity.changeState(playerIn.field_70170_p.func_180495_p(tileEntity.func_174877_v()), false);
            }
        });
    }
}

