/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.block;

import com.tfar.metalbarrels.tile.MetalBarrelBlockEntity;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MetalBarrelBlock
extends BarrelBlock {
    protected final Supplier<TileEntity> tileEntitySupplier;

    public MetalBarrelBlock(AbstractBlock.Properties properties, Supplier<TileEntity> tileEntitySupplier) {
        super(properties);
        this.tileEntitySupplier = tileEntitySupplier;
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof MetalBarrelBlockEntity) {
                MetalBarrelBlock.dropItems((MetalBarrelBlockEntity)tileentity, worldIn, pos);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(MetalBarrelBlockEntity barrel, World world, BlockPos pos) {
        IntStream.range(0, barrel.handler.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)barrel.handler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        INamedContainerProvider tileEntity;
        if (!world.field_72995_K && (tileEntity = this.func_220052_b(state, world, pos)) != null) {
            MetalBarrelBlockEntity metalBarrelBlockEntity = (MetalBarrelBlockEntity)tileEntity;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(true)), 3);
            if (metalBarrelBlockEntity.players == 0) {
                metalBarrelBlockEntity.soundStuff(state, SoundEvents.field_219602_O);
                metalBarrelBlockEntity.changeState(state, true);
            }
            ++metalBarrelBlockEntity.players;
            player.func_213829_a(tileEntity);
            player.func_195066_a(Stats.field_219732_ap);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.tileEntitySupplier.get();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity barrel = world.func_175625_s(pos);
        return barrel instanceof MetalBarrelBlockEntity ? ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((MetalBarrelBlockEntity)barrel).handler) : 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof MetalBarrelBlockEntity) {
            ((MetalBarrelBlockEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }
}

