/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.StencilElement;
import javax.annotation.Nonnull;

public class CombinedStencilElement
extends StencilElement {
    private StencilElement element1;
    private StencilElement element2;
    private ElementMode mode;

    private CombinedStencilElement() {
    }

    public static CombinedStencilElement of(@Nonnull StencilElement element1, @Nonnull StencilElement element2) {
        return CombinedStencilElement.of(element1, element2, ElementMode.FIRST);
    }

    public static CombinedStencilElement of(@Nonnull StencilElement element1, @Nonnull StencilElement element2, ElementMode mode) {
        CombinedStencilElement e = new CombinedStencilElement();
        e.element1 = element1;
        e.element2 = element2;
        e.mode = mode;
        return e;
    }

    public <T extends CombinedStencilElement> T withFirst(StencilElement element) {
        this.element1 = element;
        return (T)this;
    }

    public <T extends CombinedStencilElement> T withSecond(StencilElement element) {
        this.element2 = element;
        return (T)this;
    }

    public <T extends CombinedStencilElement> T withMode(ElementMode mode) {
        this.mode = mode;
        return (T)this;
    }

    @Override
    protected void renderStencil(MatrixStack ms) {
        ms.func_227860_a_();
        this.element1.transform(ms);
        this.element1.withBounds(this.width, this.height);
        this.element1.renderStencil(ms);
        ms.func_227865_b_();
        ms.func_227860_a_();
        this.element2.transform(ms);
        this.element2.withBounds(this.width, this.height);
        this.element2.renderStencil(ms);
        ms.func_227865_b_();
    }

    @Override
    protected void renderElement(MatrixStack ms) {
        if (this.mode.rendersFirst()) {
            ((StencilElement)this.element1.withBounds(this.width, this.height)).renderElement(ms);
        }
        if (this.mode.rendersSecond()) {
            ((StencilElement)this.element2.withBounds(this.width, this.height)).renderElement(ms);
        }
    }

    public static enum ElementMode {
        FIRST,
        SECOND,
        BOTH;


        boolean rendersFirst() {
            return this == FIRST || this == BOTH;
        }

        boolean rendersSecond() {
            return this == SECOND || this == BOTH;
        }
    }
}

