/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.tools.ExtendoGripInteractionPacket;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExtendoGripItem
extends Item {
    private static DamageSource lastActiveDamageSource;
    public static final int MAX_DAMAGE = 200;
    public static final AttributeModifier singleRangeAttributeModifier;
    public static final AttributeModifier doubleRangeAttributeModifier;
    static LazyValue<Multimap<Attribute, AttributeModifier>> rangeModifier;
    static LazyValue<Multimap<Attribute, AttributeModifier>> doubleRangeModifier;
    public static final String EXTENDO_MARKER = "createExtendo";
    public static final String DUAL_EXTENDO_MARKER = "createDualExtendo";

    public ExtendoGripItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    @SubscribeEvent
    public static void holdingExtendoGripIncreasesRange(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        CompoundNBT persistentData = player.getPersistentData();
        boolean inOff = AllItems.EXTENDO_GRIP.isIn(player.func_184592_cb());
        boolean inMain = AllItems.EXTENDO_GRIP.isIn(player.func_184614_ca());
        boolean holdingDualExtendo = inOff && inMain;
        boolean holdingExtendo = inOff ^ inMain;
        boolean bl = !holdingDualExtendo;
        boolean wasHoldingExtendo = persistentData.func_74764_b(EXTENDO_MARKER);
        boolean wasHoldingDualExtendo = persistentData.func_74764_b(DUAL_EXTENDO_MARKER);
        if ((holdingExtendo &= bl) != wasHoldingExtendo) {
            if (!holdingExtendo) {
                player.func_233645_dx_().func_233785_a_((Multimap)rangeModifier.func_179281_c());
                persistentData.func_82580_o(EXTENDO_MARKER);
            } else {
                if (player instanceof ServerPlayerEntity) {
                    AllTriggers.EXTENDO.trigger((ServerPlayerEntity)player);
                }
                player.func_233645_dx_().func_233793_b_((Multimap)rangeModifier.func_179281_c());
                persistentData.func_74757_a(EXTENDO_MARKER, true);
            }
        }
        if (holdingDualExtendo != wasHoldingDualExtendo) {
            if (!holdingDualExtendo) {
                player.func_233645_dx_().func_233785_a_((Multimap)doubleRangeModifier.func_179281_c());
                persistentData.func_82580_o(DUAL_EXTENDO_MARKER);
            } else {
                if (player instanceof ServerPlayerEntity) {
                    AllTriggers.GIGA_EXTENDO.trigger((ServerPlayerEntity)player);
                }
                player.func_233645_dx_().func_233793_b_((Multimap)doubleRangeModifier.func_179281_c());
                persistentData.func_74757_a(DUAL_EXTENDO_MARKER, true);
            }
        }
    }

    @SubscribeEvent
    public static void addReachToJoiningPlayersHoldingExtendo(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        CompoundNBT persistentData = player.getPersistentData();
        if (persistentData.func_74764_b(DUAL_EXTENDO_MARKER)) {
            player.func_233645_dx_().func_233793_b_((Multimap)doubleRangeModifier.func_179281_c());
        } else if (persistentData.func_74764_b(EXTENDO_MARKER)) {
            player.func_233645_dx_().func_233793_b_((Multimap)rangeModifier.func_179281_c());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void dontMissEntitiesWhenYouHaveHighReachDistance(InputEvent.ClickInputEvent event) {
        AxisAlignedBB axisalignedbb;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (mc.field_71441_e == null || player == null) {
            return;
        }
        if (!ExtendoGripItem.isHoldingExtendoGrip((PlayerEntity)player)) {
            return;
        }
        if (mc.field_71476_x instanceof BlockRayTraceResult && mc.field_71476_x.func_216346_c() != RayTraceResult.Type.MISS) {
            return;
        }
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        if (!player.func_184812_l_()) {
            d0 -= 0.5;
        }
        Vector3d Vector3d2 = player.func_174824_e(AnimationTickHolder.getPartialTicks());
        Vector3d Vector3d1 = player.func_70676_i(1.0f);
        Vector3d Vector3d22 = Vector3d2.func_72441_c(Vector3d1.field_72450_a * d0, Vector3d1.field_72448_b * d0, Vector3d1.field_72449_c * d0);
        EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)player, (Vector3d)Vector3d2, (Vector3d)Vector3d22, (AxisAlignedBB)(axisalignedbb = player.func_174813_aQ().func_216361_a(Vector3d1.func_186678_a(d0)).func_72314_b(1.0, 1.0, 1.0)), e -> !e.func_175149_v() && e.func_70067_L(), (double)(d0 * d0));
        if (entityraytraceresult != null) {
            Entity entity1 = entityraytraceresult.func_216348_a();
            Vector3d Vector3d3 = entityraytraceresult.func_216347_e();
            double d2 = Vector3d2.func_72436_e(Vector3d3);
            if (d2 < d0 * d0 || mc.field_71476_x == null || mc.field_71476_x.func_216346_c() == RayTraceResult.Type.MISS) {
                mc.field_71476_x = entityraytraceresult;
                if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrameEntity) {
                    mc.field_147125_j = entity1;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnBlockBreak(BlockEvent.BreakEvent event) {
        ExtendoGripItem.findAndDamageExtendoGrip(event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            ExtendoGripItem.findAndDamageExtendoGrip((PlayerEntity)entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnPlace(PlayerInteractEvent event) {
    }

    private static void findAndDamageExtendoGrip(PlayerEntity player) {
        if (player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Hand hand = Hand.MAIN_HAND;
        ItemStack extendo = player.func_184614_ca();
        if (!AllItems.EXTENDO_GRIP.isIn(extendo)) {
            extendo = player.func_184592_cb();
            hand = Hand.OFF_HAND;
        }
        if (!AllItems.EXTENDO_GRIP.isIn(extendo)) {
            return;
        }
        Hand h = hand;
        if (!BackTankUtil.canAbsorbDamage((LivingEntity)player, ExtendoGripItem.maxUses())) {
            extendo.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(h));
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return BackTankUtil.getRGBDurabilityForDisplay(stack, ExtendoGripItem.maxUses());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return BackTankUtil.getDurabilityForDisplay(stack, ExtendoGripItem.maxUses());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return BackTankUtil.showDurabilityBar(stack, ExtendoGripItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.SERVER.curiosities.maxExtendoGripActions.get();
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return 200;
    }

    @SubscribeEvent
    public static void bufferLivingAttackEvent(LivingAttackEvent event) {
        lastActiveDamageSource = event.getSource();
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity trueSource = source.func_76346_g();
        if (trueSource instanceof PlayerEntity) {
            ExtendoGripItem.findAndDamageExtendoGrip((PlayerEntity)trueSource);
        }
    }

    @SubscribeEvent
    public static void attacksByExtendoGripHaveMoreKnockback(LivingKnockBackEvent event) {
        if (lastActiveDamageSource == null) {
            return;
        }
        Entity entity = lastActiveDamageSource.func_76364_f();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (!ExtendoGripItem.isHoldingExtendoGrip(player)) {
            return;
        }
        event.setStrength(event.getStrength() + 2.0f);
    }

    private static boolean isUncaughtClientInteraction(Entity entity, Entity target) {
        if (entity.func_70068_e(target) < 36.0) {
            return false;
        }
        if (!entity.field_70170_p.field_72995_K) {
            return false;
        }
        return entity instanceof PlayerEntity;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeAttacks(AttackEntityEvent event) {
        Entity target;
        Entity entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction(entity, target = event.getTarget())) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.channel.sendToServer((Object)new ExtendoGripInteractionPacket(target));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeInteractions(PlayerInteractEvent.EntityInteract event) {
        Entity target;
        Entity entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction(entity, target = event.getTarget())) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.channel.sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand()));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeSpecificInteractions(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target;
        Entity entity = event.getEntity();
        if (!ExtendoGripItem.isUncaughtClientInteraction(entity, target = event.getTarget())) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (ExtendoGripItem.isHoldingExtendoGrip(player)) {
            AllPackets.channel.sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand(), event.getLocalPos()));
        }
    }

    public static boolean isHoldingExtendoGrip(PlayerEntity player) {
        boolean inOff = AllItems.EXTENDO_GRIP.isIn(player.func_184592_cb());
        boolean inMain = AllItems.EXTENDO_GRIP.isIn(player.func_184614_ca());
        boolean holdingGrip = inOff || inMain;
        return holdingGrip;
    }

    static {
        singleRangeAttributeModifier = new AttributeModifier(UUID.fromString("7f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range modifier", 3.0, AttributeModifier.Operation.ADDITION);
        doubleRangeAttributeModifier = new AttributeModifier(UUID.fromString("8f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range modifier", 5.0, AttributeModifier.Operation.ADDITION);
        rangeModifier = new LazyValue(() -> ImmutableMultimap.of((Object)ForgeMod.REACH_DISTANCE.get(), (Object)singleRangeAttributeModifier));
        doubleRangeModifier = new LazyValue(() -> ImmutableMultimap.of((Object)ForgeMod.REACH_DISTANCE.get(), (Object)doubleRangeAttributeModifier));
    }
}

