/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.registry.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.valhelsia.valhelsia_core.registry.AbstractRegistryHelper;
import net.valhelsia.valhelsia_core.registry.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.registry.block.CompostableHelper;
import net.valhelsia.valhelsia_core.registry.block.FlammableHelper;
import net.valhelsia.valhelsia_core.util.ValhelsiaRenderType;

public class BlockRegistryHelper
extends AbstractRegistryHelper<Block> {
    public final Map<ValhelsiaRenderType, List<Block>> renderTypes = new HashMap<ValhelsiaRenderType, List<Block>>();
    private ItemGroup defaultGroup = null;
    private final FlammableHelper flammableHelper = new FlammableHelper();
    private final CompostableHelper compostableHelper = new CompostableHelper();

    @Override
    public IForgeRegistry<Block> getRegistry() {
        return ForgeRegistries.BLOCKS;
    }

    public void setDefaultGroup(ItemGroup itemGroup) {
        this.defaultGroup = itemGroup;
    }

    public ItemGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    public ItemRegistryHelper getItemRegistryHelper() {
        return this.getRegistryManager().getItemHelper();
    }

    public FlammableHelper getFlammableHelper() {
        return this.flammableHelper;
    }

    public CompostableHelper getCompostableHelper() {
        return this.compostableHelper;
    }

    public <T extends Block> RegistryObject<T> register(String name, T block) {
        return this.register(name, block, true, this.getDefaultGroup());
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, ValhelsiaRenderType renderType) {
        return this.register(name, block, true, this.getDefaultGroup(), renderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, ItemGroup itemGroup) {
        return this.register(name, block, true, itemGroup);
    }

    public <T extends Block> RegistryObject<T> registerNoItem(String name, T block) {
        return this.register(name, block, false);
    }

    public <T extends Block> RegistryObject<T> registerNoItem(String name, T block, ValhelsiaRenderType valhelsiaRenderType) {
        return this.register(name, block, false, this.getDefaultGroup(), valhelsiaRenderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item) {
        return this.register(name, block, item, this.getDefaultGroup());
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item, ItemGroup itemGroup) {
        return this.register(name, block, item, itemGroup, ValhelsiaRenderType.SOLID);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item, ItemGroup itemGroup, ValhelsiaRenderType renderType) {
        if (item) {
            return this.register(name, block, new BlockItem(block, new Item.Properties().func_200916_a(itemGroup)), renderType);
        }
        return this.registerBlock(name, block, renderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, BlockItem item) {
        return this.register(name, block, item, ValhelsiaRenderType.SOLID);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, BlockItem item, ValhelsiaRenderType renderType) {
        this.getItemRegistryHelper().register(name, () -> item);
        return this.registerBlock(name, block, renderType);
    }

    private <T extends Block> RegistryObject<T> registerBlock(String name, T block, ValhelsiaRenderType renderType) {
        if (renderType != ValhelsiaRenderType.SOLID) {
            this.renderTypes.computeIfAbsent(renderType, k -> new ArrayList());
            this.renderTypes.get((Object)renderType).add(block);
        }
        return this.deferredRegister.register(name, () -> block);
    }

    public RegistryObject<RotatedPillarBlock> registerLogBlock(String name, MaterialColor topColor, MaterialColor barkColor) {
        return this.register(name, new RotatedPillarBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? topColor : barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)), true, this.getDefaultGroup());
    }
}

