/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.loot.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AppendLootTableModifier
extends LootModifier {
    private final ResourceLocation lootTable;
    boolean reentryPrevention = false;

    public AppendLootTableModifier(ILootCondition[] conditions, ResourceLocation lootTable) {
        super(conditions);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.reentryPrevention) {
            return generatedLoot;
        }
        this.reentryPrevention = true;
        LootTable lootTable = context.func_227502_a_(this.lootTable);
        List extras = lootTable.func_216113_a(context);
        generatedLoot.addAll(extras);
        this.reentryPrevention = false;
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AppendLootTableModifier> {
        private static final Gson GSON = LootSerializers.func_237386_a_().create();

        public AppendLootTableModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            ResourceLocation lootTable = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"add_loot"));
            return new AppendLootTableModifier(conditions, lootTable);
        }

        public JsonObject write(AppendLootTableModifier instance) {
            JsonObject object = new JsonObject();
            object.addProperty("add_loot", instance.lootTable.toString());
            JsonElement conditions = GSON.toJsonTree((Object)instance.conditions);
            object.add("conditions", conditions);
            return object;
        }
    }
}

