/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FlintAndSteelHelper {
    private static final List<FlintAndSteelUse> USES = new ArrayList<FlintAndSteelUse>();

    public static void addUse(Predicate<BlockState> unlitState, Function<BlockState, BlockState> litState, IActionResultType resultType) {
        FlintAndSteelHelper.addUse(unlitState, litState, null, resultType);
    }

    public static void addUse(Predicate<BlockState> unlitState, Function<BlockState, BlockState> litState, @Nullable IUseEffect useEffect, IActionResultType resultType) {
        USES.add(new FlintAndSteelUse(unlitState, litState, useEffect, resultType));
    }

    public static List<FlintAndSteelUse> getUses() {
        return USES;
    }

    public static interface IActionResultType {
        public ActionResultType getResult(World var1);
    }

    public static interface IUseEffect {
        public void playEffect(PlayerEntity var1, World var2, BlockPos var3);
    }

    public static class FlintAndSteelUse {
        private final Predicate<BlockState> unlitState;
        private final Function<BlockState, BlockState> litState;
        @Nullable
        private final IUseEffect useEffect;
        private final IActionResultType resultType;

        private FlintAndSteelUse(Predicate<BlockState> unlitState, Function<BlockState, BlockState> litState, @Nullable IUseEffect useEffect, IActionResultType resultType) {
            this.unlitState = unlitState;
            this.litState = litState;
            this.useEffect = useEffect;
            this.resultType = resultType;
        }

        public Predicate<BlockState> getUnlitState() {
            return this.unlitState;
        }

        public Function<BlockState, BlockState> getLitState() {
            return this.litState;
        }

        @Nullable
        public IUseEffect getUseEffect() {
            return this.useEffect;
        }

        public ActionResultType getResultType(World world) {
            return this.resultType.getResult(world);
        }
    }
}

