/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;

public class ValhelsiaCapeLayer<T extends AbstractClientPlayerEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    private final ValhelsiaCapeModel<T> model = new ValhelsiaCapeModel();

    public ValhelsiaCapeLayer(LivingRenderer<T, PlayerModel<T>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = player.func_110124_au();
        List<Cosmetic> cosmetics = cosmeticsManager.getCosmeticsForPlayer(uuid, CosmeticsCategory.BACK);
        Cosmetic activeCosmetic = cosmeticsManager.getActiveCosmeticForPlayer(uuid, CosmeticsCategory.BACK);
        if (stack.func_77973_b() == Items.field_185160_cR || activeCosmetic == null || !activeCosmetic.getName().contains("cape") || !cosmetics.contains(activeCosmetic)) {
            return;
        }
        ResourceLocation texture = cosmeticsManager.getCosmeticTexture(activeCosmetic);
        if (texture == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.2);
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_71091_bM, (double)((AbstractClientPlayerEntity)player).field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_70169_q, (double)player.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_71096_bN, (double)((AbstractClientPlayerEntity)player).field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_70167_r, (double)player.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_71097_bO, (double)((AbstractClientPlayerEntity)player).field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)((AbstractClientPlayerEntity)player).field_70166_s, (double)player.func_226281_cx_());
        float f = ((AbstractClientPlayerEntity)player).field_70760_ar + (((AbstractClientPlayerEntity)player).field_70761_aq - ((AbstractClientPlayerEntity)player).field_70760_ar);
        double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = MathHelper.func_219799_g((float)partialTicks, (float)((AbstractClientPlayerEntity)player).field_71107_bF, (float)((AbstractClientPlayerEntity)player).field_71109_bG);
        f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)((AbstractClientPlayerEntity)player).field_70141_P, (float)((AbstractClientPlayerEntity)player).field_70140_Q) * 6.0f)) * 32.0f * f4;
        if (player.func_213453_ef()) {
            f1 += player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() ? 25.0f : 35.0f;
            matrixStack.func_227861_a_(0.0, 0.2, 0.0);
        }
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)texture));
        matrixStack.func_227861_a_(0.0, 0.05, 0.0);
        this.model.renderPin(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -0.05, 0.0);
        float xRotation = 6.0f + f2 / 2.0f + f1;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(xRotation));
        this.model.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

