/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.valhelsia.valhelsia_core.capability.counter.CounterImpl;
import net.valhelsia.valhelsia_core.capability.counter.CounterStorage;
import net.valhelsia.valhelsia_core.capability.counter.ICounterCapability;
import net.valhelsia.valhelsia_core.config.Config;
import net.valhelsia.valhelsia_core.init.ValhelsiaLootConditions;
import net.valhelsia.valhelsia_core.network.NetworkHandler;
import net.valhelsia.valhelsia_core.registry.LootModifierRegistryHelper;
import net.valhelsia.valhelsia_core.registry.RegistryManager;
import net.valhelsia.valhelsia_core.setup.ClientSetup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="valhelsia_core")
public class ValhelsiaCore {
    public static final String MOD_ID = "valhelsia_core";
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean allConfigsValidated = false;
    public static final List<RegistryManager> REGISTRY_MANAGERS = new ArrayList<RegistryManager>();
    public static final RegistryManager REGISTRY_MANAGER = new RegistryManager.Builder("valhelsia_core").addHelpers(new LootModifierRegistryHelper()).build();

    public ValhelsiaCore() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::new);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerLootConditions);
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_MANAGER.register(eventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.init();
        CapabilityManager.INSTANCE.register(ICounterCapability.class, (Capability.IStorage)new CounterStorage(), CounterImpl::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void registerLootConditions(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(MOD_ID, "match_block"), (Object)ValhelsiaLootConditions.MATCH_BLOCK);
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(MOD_ID, "date"), (Object)ValhelsiaLootConditions.DATE);
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(MOD_ID, "entity_tag"), (Object)ValhelsiaLootConditions.ENTITY_TAG);
    }
}

