/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class InstantPrintPacket {
    private BunchOfBlocks blocks;

    public InstantPrintPacket() {
    }

    public InstantPrintPacket(BunchOfBlocks blocks) {
        this.blocks = blocks;
    }

    public InstantPrintPacket(PacketBuffer buf) {
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            CompoundNBT blockTag = buf.func_150793_b();
            BlockPos pos = buf.func_179259_c();
            blocks.put(pos, NBTUtil.func_190008_d((CompoundNBT)blockTag));
        }
        this.blocks = new BunchOfBlocks(blocks);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.blocks.size);
        this.blocks.blocks.forEach((pos, state) -> {
            buf.func_150786_a(NBTUtil.func_190009_a((BlockState)state));
            buf.func_179255_a(pos);
        });
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> this.blocks.blocks.forEach((pos, state) -> ctx.getSender().func_130014_f_().func_180501_a(pos, state, 3)));
    }

    public static List<InstantPrintPacket> sendSchematic(Map<BlockPos, BlockState> blockMap, BlockPos anchor) {
        LinkedList<InstantPrintPacket> packets = new LinkedList<InstantPrintPacket>();
        HashMap<Object, Object> currentMap = new HashMap<BlockPos, BlockState>(32);
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(blockMap.keySet());
        for (int i = 0; i < blockMap.size(); ++i) {
            if (currentMap.size() >= 32) {
                packets.add(new InstantPrintPacket(new BunchOfBlocks(currentMap)));
                currentMap = new HashMap(32);
            }
            currentMap.put(((BlockPos)posList.get(i)).func_177971_a((Vector3i)anchor), blockMap.get(posList.get(i)));
        }
        packets.add(new InstantPrintPacket(new BunchOfBlocks(currentMap)));
        return packets;
    }

    static class BunchOfBlocks {
        static final int MAX_SIZE = 32;
        Map<BlockPos, BlockState> blocks;
        int size;

        public BunchOfBlocks(Map<BlockPos, BlockState> blocks) {
            this.blocks = blocks;
            this.size = blocks.size();
        }
    }
}

