/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui.widgets;

import com.simibubi.mightyarchitect.gui.widgets.AbstractSimiWidget;
import com.simibubi.mightyarchitect.gui.widgets.Label;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected Label displayLabel;
    protected ITextComponent title = new StringTextComponent("Choose an Option");
    protected ITextComponent scrollToModify = new StringTextComponent("Scroll to Modify");
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(String title) {
        this.title = new StringTextComponent(title);
        this.updateTooltip();
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        this.writeToLabel();
        return this;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.field_230692_n_) {
            return false;
        }
        int priorState = this.state;
        boolean shifted = Screen.func_231173_s_();
        int step = (int)Math.signum(delta);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = new StringTextComponent(String.valueOf(this.state));
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add(this.title.func_230531_f_().func_240699_a_(TextFormatting.BLUE));
        this.toolTip.add(this.scrollToModify.func_230531_f_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
    }
}

