/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.gui.widgets.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class Label
extends AbstractSimiWidget {
    public ITextComponent text;
    public String suffix;
    protected boolean hasShadow;
    protected int color;
    protected FontRenderer font;

    public Label(int x, int y, String tooltip) {
        this(x, y, (ITextComponent)new StringTextComponent(tooltip));
    }

    public Label(int x, int y, ITextComponent text) {
        super(x, y, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)text), 10);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.text = new StringTextComponent("Label");
        this.color = 0xFFFFFF;
        this.hasShadow = false;
        this.suffix = "";
    }

    public Label colored(int color) {
        this.color = color;
        return this;
    }

    public Label withShadow() {
        this.hasShadow = true;
        return this;
    }

    public Label withSuffix(String s) {
        this.suffix = s;
        return this;
    }

    public void setText(String text) {
        this.text = new StringTextComponent(text);
    }

    public void setTextAndTrim(ITextComponent newText, boolean trimFront, int maxWidthPx) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (fontRenderer.func_238414_a_((ITextProperties)newText) <= maxWidthPx) {
            this.text = newText;
            return;
        }
        String trim = "...";
        int trimWidth = fontRenderer.func_78256_a(trim);
        String raw = newText.getString();
        StringBuilder builder = new StringBuilder(raw);
        int startIndex = trimFront ? 0 : raw.length() - 1;
        int endIndex = !trimFront ? 0 : raw.length() - 1;
        int step = (int)Math.signum(endIndex - startIndex);
        for (int i = startIndex; i != endIndex; i += step) {
            String sub = builder.substring(trimFront ? i : startIndex, trimFront ? endIndex + 1 : i + 1);
            if (fontRenderer.func_238414_a_((ITextProperties)new StringTextComponent(sub).func_230530_a_(newText.func_150256_b())) + trimWidth > maxWidthPx) continue;
            this.text = new StringTextComponent(trimFront ? trim + sub : sub + trim).func_230530_a_(newText.func_150256_b());
            return;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_230694_p_) {
            return;
        }
        if (this.text == null || this.text.getString().isEmpty()) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IFormattableTextComponent copy = this.text.func_230531_f_();
        if (this.suffix != null && !this.suffix.isEmpty()) {
            copy.func_240702_b_(this.suffix);
        }
        if (this.hasShadow) {
            this.font.func_243246_a(matrixStack, (ITextComponent)copy, (float)this.field_230690_l_, (float)this.field_230691_m_, this.color);
        } else {
            this.font.func_243248_b(matrixStack, (ITextComponent)copy, (float)this.field_230690_l_, (float)this.field_230691_m_, this.color);
        }
    }
}

