/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.palette.PaletteStorage;
import com.simibubi.mightyarchitect.foundation.utility.FilesHelper;
import com.simibubi.mightyarchitect.gui.AbstractSimiScreen;
import com.simibubi.mightyarchitect.gui.GuiGameElement;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import com.simibubi.mightyarchitect.gui.widgets.IconButton;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class PalettePickerScreen
extends AbstractSimiScreen {
    private PaletteButton primary;
    private PaletteButton secondary;
    private IconButton buttonAddPalette;
    private IconButton buttonOpenFolder;
    private IconButton buttonRefresh;
    private boolean scanPicker;

    public PalettePickerScreen() {
        this(false);
    }

    public PalettePickerScreen(boolean scanPicker) {
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.scanPicker = scanPicker;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.setWindowSize(256, 236);
        this.widgets.clear();
        this.updateSelected();
        int id = 2;
        int x = this.topLeftX + 10;
        int y = this.topLeftY + 68;
        for (String paletteName : PaletteStorage.getResourcePaletteNames()) {
            this.widgets.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id, x + (id - 2) % 5 * 23, y + (id - 2) / 5 * 23));
            ++id;
        }
        int i = 0;
        x = this.topLeftX + 135;
        y = this.topLeftY + 68;
        for (String paletteName : PaletteStorage.getPaletteNames()) {
            this.widgets.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id + i, x + i % 5 * 23, y + i / 5 * 23));
            ++i;
        }
        if (!this.scanPicker) {
            this.buttonAddPalette = new IconButton(x + i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_ADD);
            this.buttonAddPalette.setToolTip((ITextComponent)new StringTextComponent("Create Palette"));
            this.buttonAddPalette.getToolTip().add((ITextComponent)new StringTextComponent("Will use currently selected").func_240699_a_(TextFormatting.GRAY));
            this.buttonAddPalette.getToolTip().add((ITextComponent)new StringTextComponent("Palette as the template.").func_240699_a_(TextFormatting.GRAY));
            ++i;
            this.widgets.add(this.buttonAddPalette);
        }
        this.buttonOpenFolder = new IconButton(x + i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_FOLDER);
        this.buttonOpenFolder.setToolTip((ITextComponent)new StringTextComponent("Open Palette Folder"));
        this.widgets.add(this.buttonOpenFolder);
        this.buttonRefresh = new IconButton(x + ++i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_REFRESH);
        this.buttonRefresh.setToolTip((ITextComponent)new StringTextComponent("Refresh Imported Palettes"));
        this.widgets.add(this.buttonRefresh);
        ++i;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.scanPicker) {
            if (this.primary.palette.hasDuplicates()) {
                this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Warning: Ambiguous Scanner Palette " + TextFormatting.WHITE + "( " + this.primary.palette.getDuplicates() + " )"), false);
            }
            this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Updated Default Palette"), true);
            DesignExporter.theme.setDefaultPalette(this.primary.palette);
            DesignExporter.theme.setDefaultSecondaryPalette(this.secondary.palette);
        }
    }

    private void updateSelected() {
        if (this.widgets.contains((Object)this.primary)) {
            this.widgets.remove((Object)this.primary);
        }
        if (this.widgets.contains((Object)this.secondary)) {
            this.widgets.remove((Object)this.secondary);
        }
        if (this.scanPicker) {
            this.primary = new PaletteButton(DesignExporter.scanningPalette, this, 0, this.topLeftX + 135, this.topLeftY + 8);
            this.primary.field_230693_o_ = false;
            this.secondary = new PaletteButton(DesignExporter.theme.getDefaultSecondaryPalette(), this, 1, this.topLeftX + 192, this.topLeftY + 8);
            this.secondary.field_230693_o_ = false;
            this.widgets.add(this.primary);
            this.widgets.add(this.secondary);
            return;
        }
        this.primary = new PaletteButton(ArchitectManager.getModel().getPrimary(), this, 0, this.topLeftX + 135, this.topLeftY + 8);
        this.primary.field_230693_o_ = false;
        this.secondary = new PaletteButton(ArchitectManager.getModel().getSecondary(), this, 1, this.topLeftX + 192, this.topLeftY + 8);
        this.secondary.field_230693_o_ = false;
        this.widgets.add(this.primary);
        this.widgets.add(this.secondary);
    }

    @Override
    public void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        ScreenResources.PALETTES.draw(ms, (AbstractGui)this, this.topLeftX, this.topLeftY);
        int color = 5726074;
        if (this.scanPicker) {
            this.field_230712_o_.func_238421_b_(ms, "Choose a palette for", (float)(this.topLeftX + 8), (float)(this.topLeftY + 10), color);
            this.field_230712_o_.func_238421_b_(ms, "your theme.", (float)(this.topLeftX + 8), (float)(this.topLeftY + 18), color);
        } else {
            this.field_230712_o_.func_238421_b_(ms, "Palette Picker", (float)(this.topLeftX + 8), (float)(this.topLeftY + 10), color);
            this.field_230712_o_.func_238421_b_(ms, "Primary", (float)(this.topLeftX + 134), (float)(this.topLeftY + 30), color);
            this.field_230712_o_.func_238421_b_(ms, "Secondary", (float)(this.topLeftX + 191), (float)(this.topLeftY + 30), color);
        }
        this.field_230712_o_.func_238421_b_(ms, "Included Palettes", (float)(this.topLeftX + 8), (float)(this.topLeftY + 53), color);
        this.field_230712_o_.func_238421_b_(ms, "My Palettes", (float)(this.topLeftX + 134), (float)(this.topLeftY + 53), color);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget guibutton = (Widget)this.widgets.get(i);
            if (!guibutton.func_231047_b_(mouseX, mouseY)) continue;
            guibutton.func_230988_a_(this.field_230706_i_.func_147118_V());
            if (mouseButton == 0) {
                this.buttonClicked(guibutton);
            }
            if (mouseButton == 1) {
                this.buttonRightClicked(guibutton);
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected void buttonClicked(Widget button) {
        if (button == this.buttonOpenFolder) {
            FilesHelper.createFolderIfMissing("palettes");
            Util.func_110647_a().func_195641_a(Paths.get("palettes/", new String[0]).toFile());
        }
        if (button == this.buttonRefresh) {
            PaletteStorage.loadAllPalettes();
            this.func_231160_c_();
        }
        if (this.scanPicker) {
            if (button instanceof PaletteButton) {
                DesignExporter.scanningPalette = ((PaletteButton)button).palette;
            }
            this.updateSelected();
            return;
        }
        if (!(button instanceof PaletteButton)) {
            if (button == this.buttonAddPalette) {
                ArchitectManager.createPalette(true);
                this.field_230706_i_.func_147108_a(null);
            }
        } else {
            ArchitectManager.getModel().swapPrimaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            MightyClient.renderer.update();
        }
    }

    protected void buttonRightClicked(Widget button) {
        if (this.scanPicker) {
            if (button instanceof PaletteButton) {
                DesignExporter.theme.setDefaultSecondaryPalette(((PaletteButton)button).palette);
            }
            this.updateSelected();
            return;
        }
        if (!(button instanceof PaletteButton)) {
            ArchitectManager.createPalette(false);
            this.field_230706_i_.func_147108_a(null);
        } else {
            ArchitectManager.getModel().swapSecondaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            MightyClient.renderer.update();
        }
    }

    class PaletteButton
    extends IconButton {
        Screen parent;
        PaletteDefinition palette;

        public PaletteButton(PaletteDefinition palette, Screen parent, int buttonId, int x, int y) {
            super(x, y, ScreenResources.ICON_NONE);
            this.parent = parent;
            this.palette = palette;
            this.field_230694_p_ = true;
            this.field_230693_o_ = true;
        }

        private void preview(MatrixStack ms, Minecraft mc) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.field_230690_l_ + 5), (float)(this.field_230691_m_ + 9), (float)100.0f);
            RenderSystem.rotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlock(ms, mc, new BlockPos(0, 1, 0), Palette.INNER_PRIMARY);
            this.renderBlock(ms, mc, new BlockPos(1, 1, 0), Palette.INNER_DETAIL);
            this.renderBlock(ms, mc, new BlockPos(0, 0, 0), Palette.HEAVY_PRIMARY);
            this.renderBlock(ms, mc, new BlockPos(1, 0, 0), Palette.ROOF_PRIMARY);
            RenderSystem.popMatrix();
        }

        protected void renderBlock(MatrixStack ms, Minecraft mc, BlockPos pos, Palette key) {
            RenderSystem.pushMatrix();
            GuiGameElement.of(this.palette.get(key)).atLocal(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).scale(7.9f).render(ms);
            RenderSystem.popMatrix();
        }

        @Override
        public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(ms, mouseX, mouseY, partialTicks);
            this.preview(ms, PalettePickerScreen.this.field_230706_i_);
        }

        public void func_230443_a_(MatrixStack ms, int mouseX, int mouseY) {
            if (this.field_230692_n_) {
                PalettePickerScreen.this.func_238652_a_(ms, (ITextComponent)new StringTextComponent(this.palette.getName()), mouseX, mouseY);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

