/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.ArchitectMenu;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ArchitectMenuScreen
extends Screen {
    private ArchitectMenu.KeyBindList keybinds = new ArchitectMenu.KeyBindList();
    private String title = "";
    private List<String> tooltip = new ArrayList<String>();
    private boolean focused = false;
    private boolean visible = false;
    private int menuWidth;
    private int menuHeight;
    private int targetY = 0;
    private float movingY = 0.0f;

    public ArchitectMenuScreen() {
        super((ITextComponent)new StringTextComponent("Architect Menu"));
        this.adjustTarget();
    }

    public void updateContents() {
        Minecraft.func_71410_x().field_71466_p.getClass();
        int textRendererheight = 9;
        this.tooltip = ArchitectManager.getPhase().getPhaseHandler().getToolTip();
        this.keybinds = ArchitectMenu.getKeybinds();
        this.title = ArchitectManager.getPhase().getDisplayTitle();
        this.menuWidth = 158;
        this.menuHeight = 4;
        this.menuHeight += 12;
        this.menuHeight = (int)((float)this.menuHeight + (4.0f + this.keybinds.size() * (float)textRendererheight));
        this.menuHeight += 4;
        for (String s : this.tooltip) {
            this.menuHeight += Minecraft.func_71410_x().field_71466_p.func_78267_b(s, this.menuWidth - 8) + 2;
        }
        this.adjustTarget();
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.draw(ms, partialTicks);
    }

    public void drawPassive() {
        if (this.isFocused()) {
            return;
        }
        this.draw(new MatrixStack(), Minecraft.func_71410_x().func_184121_ak());
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean hideOnClose;
        super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        boolean bl = hideOnClose = ArchitectManager.inPhase(ArchitectPhases.Empty) || ArchitectManager.inPhase(ArchitectPhases.Paused);
        if (keyCode == 256) {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        if (keyCode == MightyClient.COMPOSE.getKey().func_197937_c()) {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        boolean hideOnClose;
        boolean bl = hideOnClose = ArchitectManager.inPhase(ArchitectPhases.Empty) || ArchitectManager.inPhase(ArchitectPhases.Paused);
        if (ArchitectMenu.handleMenuInput(p_charTyped_1_)) {
            if (ArchitectManager.inPhase(ArchitectPhases.Paused)) {
                this.setVisible(false);
            }
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        if (p_charTyped_1_ == 'e') {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    /*
     * Unable to fully structure code
     */
    private void draw(MatrixStack ms, float partialTicks) {
        mainWindow = Minecraft.func_71410_x().func_228018_at_();
        x = mainWindow.func_198107_o() - this.menuWidth - 10;
        y = mainWindow.func_198087_p() - this.menuHeight;
        mouseX = (int)(Minecraft.func_71410_x().field_71417_B.func_198024_e() / mainWindow.func_198100_s());
        mouseY = (int)(Minecraft.func_71410_x().field_71417_B.func_198026_f() / mainWindow.func_198100_s());
        sideways = false;
        if ((mainWindow.func_198107_o() - 182) / 2 < this.menuWidth + 20) {
            sideways = true;
            y -= 24;
        }
        RenderSystem.pushMatrix();
        shift = this.yShift(partialTicks);
        sidewaysShift = shift * ((float)this.menuWidth / (float)this.menuHeight) + (this.focused == false ? 40.0f + (float)this.menuHeight / 4.0f : 0.0f) + 8.0f;
        RenderSystem.translatef((float)(sideways != false ? sidewaysShift : 0.0f), (float)(sideways != false ? 0.0f : shift), (float)0.0f);
        mouseX = (int)((float)mouseX - (sideways != false ? sidewaysShift : 0.0f));
        mouseY = (int)((float)mouseY - (sideways != false ? 0.0f : shift));
        gray = ScreenResources.GRAY;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        RenderSystem.enableTexture();
        ArchitectMenuScreen.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)gray.startX, (float)gray.startY, (int)this.menuWidth, (int)this.menuHeight, (int)gray.width, (int)gray.height);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        yPos = y + 4;
        xPos = x + 4;
        textRenderer = Minecraft.func_71410_x().field_71466_p;
        compose = MightyClient.COMPOSE.func_238171_j_().getString().toUpperCase();
        if (!this.focused) {
            if (sideways) {
                if (this.visible) {
                    string = "Press " + compose.toUpperCase() + " for Menu";
                    textRenderer.func_238405_a_(ms, string, (float)(mainWindow.func_198107_o() - textRenderer.func_78256_a(string) - 15) - sidewaysShift, (float)(yPos - 14), 0xEEEEEE);
                }
            } else {
                textRenderer.func_238405_a_(ms, "Press " + compose.toUpperCase() + " to focus", (float)xPos, (float)(yPos - 14), 0xEEEEEE);
            }
        } else {
            string = "Press " + compose + " to close";
            textRenderer.func_238405_a_(ms, string, sideways != false ? Math.min((float)xPos, (float)(mainWindow.func_198107_o() - textRenderer.func_78256_a(string) - 15) - sidewaysShift) : (float)xPos, (float)(yPos - 14), 0xDDDDDD);
        }
        textRenderer.func_238405_a_(ms, this.title, (float)xPos, (float)yPos, 0xEEEEEE);
        hoveredHorizontally = x <= mouseX && mouseX <= x + this.menuWidth && this.focused != false;
        yPos += 4;
        for (String key : this.keybinds.getKeys()) {
            if (key.isEmpty()) {
                textRenderer.getClass();
                yPos += 9 / 2;
                continue;
            }
            textRenderer.getClass();
            if (!hoveredHorizontally || (yPos += 9) >= mouseY) ** GOTO lbl-1000
            textRenderer.getClass();
            if (mouseY <= yPos + 9) {
                v0 = 0xFFFFFF;
            } else lbl-1000:
            // 2 sources

            {
                v0 = 0xCCDDFF;
            }
            color = v0;
            textRenderer.func_238405_a_(ms, "[" + key + "] " + this.keybinds.get(key), (float)xPos, (float)yPos, color);
            textRenderer.func_238405_a_(ms, ">", (float)(xPos - 12), (float)yPos, color);
        }
        yPos += 4;
        textRenderer.getClass();
        yPos += 9;
        for (String text : this.tooltip) {
            height = Minecraft.func_71410_x().field_71466_p.func_78267_b(text, this.menuWidth - 8);
            lineY = yPos;
            for (IReorderingProcessor iro : textRenderer.func_238425_b_((ITextProperties)new StringTextComponent(text), this.menuWidth - 8)) {
                textRenderer.func_238422_b_(ms, iro, (float)xPos, (float)lineY, 0xEEEEEE);
                textRenderer.getClass();
                lineY += 9;
            }
            yPos += height + 2;
        }
        RenderSystem.popMatrix();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button != 0 || !this.visible || !this.focused) {
            return super.func_231044_a_(mouseX, mouseY, button);
        }
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int x = mainWindow.func_198107_o() - this.menuWidth - 10;
        int y = mainWindow.func_198087_p() - this.menuHeight;
        boolean sideways = false;
        if ((mainWindow.func_198107_o() - 182) / 2 < this.menuWidth + 20) {
            sideways = true;
            mouseY += 24.0;
        }
        float shift = this.yShift(0.0f);
        mouseY -= sideways ? 0.0 : (double)shift;
        boolean hoveredHorizontally = (double)x <= (mouseX -= sideways ? (double)(shift * 2.0f) : 0.0) && mouseX <= (double)(x + this.menuWidth);
        int yPos = y + 4;
        yPos += 4;
        for (String key : this.keybinds.getKeys()) {
            if (key.isEmpty()) {
                this.field_230712_o_.getClass();
                yPos += 9 / 2;
                continue;
            }
            this.field_230712_o_.getClass();
            yPos += 9;
            if (!hoveredHorizontally || !((double)yPos < mouseY)) continue;
            this.field_230712_o_.getClass();
            if (!(mouseY <= (double)(yPos + 9))) continue;
            this.func_231042_a_(key.toLowerCase().charAt(0), 1);
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        this.adjustTarget();
    }

    protected void adjustTarget() {
        this.targetY = this.visible ? (this.focused ? 0 : this.menuHeight - 14) : this.menuHeight + 20;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.adjustTarget();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.setFocused(false);
    }

    private float yShift(float partialTicks) {
        return this.movingY + ((float)this.targetY - this.movingY) * 0.2f * partialTicks;
    }

    public void onClientTick() {
        if (this.movingY != (float)this.targetY) {
            this.movingY = (float)((double)this.movingY + (double)((float)this.targetY - this.movingY) * 0.2);
        }
    }
}

