/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AngleHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void applyRotation(Direction direction, MatrixStack ms) {
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(AngleHelper.horizontalAngle(direction)));
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(AngleHelper.verticalAngle(direction)));
    }

    public static float horizontalAngle(Direction facing) {
        float angle = facing.func_185119_l();
        if (facing.func_176740_k() == Direction.Axis.X) {
            angle = -angle;
        }
        return angle;
    }

    public static float verticalAngle(Direction facing) {
        return facing == Direction.UP ? -90.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
    }

    public static float rad(double angle) {
        return (float)(angle / 180.0 * Math.PI);
    }

    public static float deg(double angle) {
        return (float)(angle * 180.0 / Math.PI);
    }

    public static float angleLerp(float pct, float current, float target) {
        return current + AngleHelper.getShortestAngleDiff(current, target) * pct;
    }

    public static float getShortestAngleDiff(double current, double target) {
        return (float)((((target %= 360.0) - (current %= 360.0)) % 360.0 + 540.0) % 360.0 - 180.0);
    }
}

