/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.BlockOrientation;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.util.math.BlockPos;

public class Sketch {
    public List<Design.DesignInstance> primary = new LinkedList<Design.DesignInstance>();
    public List<Design.DesignInstance> secondary = new LinkedList<Design.DesignInstance>();
    public List<Room> interior = new LinkedList<Room>();

    public Vector<Map<BlockPos, PaletteBlockInfo>> assemble() {
        Vector<Map<BlockPos, PaletteBlockInfo>> assembled = new Vector<Map<BlockPos, PaletteBlockInfo>>(2);
        HashMap<BlockPos, PaletteBlockInfo> blocksPrimary = new HashMap<BlockPos, PaletteBlockInfo>();
        HashMap<BlockPos, PaletteBlockInfo> blocksSecondary = new HashMap<BlockPos, PaletteBlockInfo>();
        for (Design.DesignInstance design : this.secondary) {
            design.getBlocks(blocksSecondary);
        }
        for (Design.DesignInstance design : this.primary) {
            design.getBlocks(blocksPrimary);
        }
        this.clean(blocksPrimary, blocksSecondary);
        this.addFloors(blocksPrimary, blocksSecondary);
        assembled.addElement(blocksPrimary);
        assembled.addElement(blocksSecondary);
        return assembled;
    }

    private void clean(Map<BlockPos, PaletteBlockInfo> blocks, Map<BlockPos, PaletteBlockInfo> blocks2) {
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (Map paletteLayer : ImmutableList.of(blocks, blocks2)) {
            for (BlockPos pos : paletteLayer.keySet()) {
                if (((PaletteBlockInfo)paletteLayer.get((Object)pos)).palette == Palette.CLEAR) {
                    toRemove.add(pos);
                    continue;
                }
                for (Room room : this.interior) {
                    if (room.designLayer.isExterior() || !room.contains(pos)) continue;
                    toRemove.add(pos);
                }
            }
        }
        toRemove.forEach(e -> {
            blocks.remove(e);
            blocks2.remove(e);
        });
    }

    private void addFloors(Map<BlockPos, PaletteBlockInfo> primary, Map<BlockPos, PaletteBlockInfo> secondary) {
        for (Room cuboid : this.interior) {
            boolean trimAbove = false;
            for (Room trim : this.interior) {
                if (trimAbove || trim.height > 1 || trim.y != cuboid.y + cuboid.height || trim.x > cuboid.x || trim.z > cuboid.z || trim.x + trim.width < cuboid.x + cuboid.width || trim.z + trim.length < cuboid.z + cuboid.length) continue;
                trimAbove = true;
            }
            if (trimAbove) continue;
            LinkedList checked = new LinkedList();
            this.interior.forEach(other -> {
                if (other == cuboid) {
                    return;
                }
                if (!other.intersects(cuboid)) {
                    return;
                }
                if (other.width * other.length > cuboid.width * cuboid.length) {
                    return;
                }
                checked.add(other);
            });
            int y = cuboid.height - 1;
            PaletteBlockInfo paletteBlockInfo = new PaletteBlockInfo(Palette.FLOOR, BlockOrientation.NONE);
            paletteBlockInfo.afterPosition = BlockOrientation.TOP_UP;
            Map<BlockPos, PaletteBlockInfo> blocks = cuboid.secondaryPalette ? secondary : primary;
            for (int x = 0; x < cuboid.width; ++x) {
                for (int z = 0; z < cuboid.length; ++z) {
                    boolean contained = false;
                    BlockPos pos = cuboid.getOrigin().func_177982_a(x, y, z);
                    for (Room other2 : checked) {
                        if (!other2.contains(pos)) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    blocks.put(pos, paletteBlockInfo);
                }
            }
        }
    }
}

