/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.foundation.WrappedWorld;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;

public class TemplateBlockAccess
extends WrappedWorld {
    private Map<BlockPos, BlockState> blocks;
    private Cuboid bounds;
    private BlockPos anchor;
    private boolean localMode;

    public TemplateBlockAccess(Map<BlockPos, BlockState> blocks, Cuboid bounds, BlockPos anchor) {
        super((World)Minecraft.func_71410_x().field_71441_e);
        this.blocks = blocks;
        this.bounds = bounds;
        this.anchor = anchor;
        this.updateBlockstates();
    }

    public void localMode(boolean local) {
        this.localMode = local;
    }

    private void updateBlockstates() {
        HashSet<BlockPos> keySet = new HashSet<BlockPos>(this.blocks.keySet());
        keySet.forEach(pos -> {
            BlockState blockState = this.blocks.get(pos);
            if (blockState == null) {
                return;
            }
            blockState.func_235734_a_((IWorld)this, pos.func_177971_a((Vector3i)this.anchor), 16);
        });
    }

    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    @Override
    public TileEntity func_175625_s(BlockPos pos) {
        return null;
    }

    @Override
    public BlockState func_180495_p(BlockPos globalPos) {
        BlockPos pos;
        BlockPos blockPos = pos = this.localMode ? globalPos : globalPos.func_177973_b((Vector3i)this.anchor);
        if (this.getBounds().contains(pos) && this.blocks.containsKey(pos)) {
            return this.blocks.get(pos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public Biome func_226691_t_(BlockPos pos) {
        return (Biome)this.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(Biomes.field_185440_P);
    }

    @Override
    public int func_201696_r(BlockPos p_201696_1_) {
        return 15;
    }

    public List<Entity> func_175674_a(Entity arg0, AxisAlignedBB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> arg0, AxisAlignedBB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }

    public int func_226658_a_(LightType lt, BlockPos p_226658_2_) {
        return lt == LightType.BLOCK ? 12 : 14;
    }

    public int func_217298_h(BlockPos pos) {
        return super.func_217298_h(pos);
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return BlockPos.field_177992_a;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return 256;
    }

    @Override
    public boolean func_217375_a(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.func_180495_p(pos));
    }

    public boolean func_175655_b(BlockPos arg0, boolean arg1) {
        return this.func_180501_a(arg0, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public boolean func_217377_a(BlockPos arg0, boolean arg1) {
        return this.func_180501_a(arg0, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public boolean func_241211_a_(BlockPos pos, BlockState state, int p_241211_3_, int p_241211_4_) {
        this.blocks.put(this.localMode ? pos : pos.func_177973_b((Vector3i)this.anchor), state);
        return true;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public Random func_201674_k() {
        return new Random();
    }

    public void func_195593_d(BlockPos p_195593_1_, Block p_195593_2_) {
    }

    @Override
    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void func_184133_a(PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    @Override
    public void func_217378_a(PlayerEntity player, int type, BlockPos pos, int data) {
    }

    public Cuboid getBounds() {
        return this.bounds;
    }
}

