/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.terrasteel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.core.network.AIOTBotaniaNetwork;
import de.melanx.aiotbotania.core.network.TerrasteelCreateBurstMesssage;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.alfsteel.ItemAlfsteelAIOT;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.relic.ItemThorRing;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemTerraSteelAIOT
extends ItemAIOTBase
implements ISequentialBreaker,
IManaItem,
IManaTooltipDisplay {
    public static final int MANA_PER_DAMAGE = 100;
    public static final float DAMAGE = 6.0f;
    public static final float SPEED = -2.2f;
    protected static final Set<Material> MATERIALS = ImmutableSet.of((Object)Material.field_151576_e, (Object)Material.field_151573_f, (Object)Material.field_151588_w, (Object)Material.field_151592_s, (Object)Material.field_76233_E, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});
    private static final Set<Material> AXE_MATERIALS = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151584_j, (Object)Material.field_215713_z);
    public static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final Map<RegistryKey<World>, Set<BlockSwapper>> blockSwappers = new HashMap<RegistryKey<World>, Set<BlockSwapper>>();
    private static boolean tickingSwappers = false;

    public ItemTerraSteelAIOT() {
        this(ItemTiers.TERRASTEEL_AIOT_ITEM_TIER);
    }

    public ItemTerraSteelAIOT(IItemTier mat) {
        super(mat, 6.0f, -2.2f, 100, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDrops);
        MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        MinecraftForge.EVENT_BUS.addListener(this::attackEntity);
        MinecraftForge.EVENT_BUS.addListener(this::onTickEnd);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y.func_77557_a(ModItems.terraSword);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap ret = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            ret = HashMultimap.create((Multimap)ret);
            if (ItemTerraSteelAIOT.isTipped(stack)) {
                ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlotType)slot, (String)"AIOT modifier", (double)0.1));
            }
        }
        return ret;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult raycast = ToolCommons.raytraceFromEntity((Entity)player, (double)10.0, (boolean)false);
        if (!player.field_70170_p.field_72995_K && raycast.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = raycast.func_216354_b();
            if (AXE_MATERIALS.contains(player.func_130014_f_().func_180495_p(raycast.func_216350_a()).func_185904_a())) {
                this.breakOtherBlockAxe(player, stack, pos, pos, face);
            } else {
                this.breakOtherBlock(player, stack, pos, pos, face);
            }
            BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
        }
        return false;
    }

    private void onEntityDrops(LivingDropsEvent e) {
        ItemStack weapon;
        if (e.isRecentlyHit() && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof PlayerEntity && !(weapon = ((PlayerEntity)e.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && weapon.func_77973_b() == this) {
            Random rand = e.getEntityLiving().field_70170_p.field_73012_v;
            int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)weapon);
            if (e.getEntityLiving() instanceof AbstractSkeletonEntity && rand.nextInt(26) <= 3 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)(e.getEntity() instanceof WitherSkeletonEntity ? Items.field_196183_dw : Items.field_196182_dv)));
            } else if (e.getEntityLiving() instanceof ZombieEntity && !(e.getEntityLiving() instanceof ZombifiedPiglinEntity) && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196186_dz));
            } else if (e.getEntityLiving() instanceof CreeperEntity && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196185_dy));
            } else if (e.getEntityLiving() instanceof PlayerEntity && rand.nextInt(11) <= 1 + looting) {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)((PlayerEntity)e.getEntityLiving()).func_146103_bH().getName());
                this.addDrop(e, stack);
            } else if (e.getEntityLiving() instanceof EntityDoppleganger && rand.nextInt(13) < 1 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)ModBlocks.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent e, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(e.getEntityLiving().field_70170_p, e.getEntityLiving().field_70142_S, e.getEntityLiving().field_70137_T, e.getEntityLiving().field_70136_U, drop);
        entityitem.func_174867_a(10);
        e.getDrops().add(entityitem);
    }

    public void trySpawnBurst(PlayerEntity player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && player.func_184825_o(0.0f) == 1.0f) {
            EntityManaBurst burst = this.getBurst(player, new ItemStack((IItemProvider)ModItems.terraSword));
            player.field_70170_p.func_217376_c((Entity)burst);
            player.func_184614_ca().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    public EntityManaBurst getBurst(PlayerEntity player, ItemStack stack) {
        return ((ItemTerraSword)ModItems.terraSword).getBurst(player, stack);
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            AIOTBotaniaNetwork.INSTANCE.sendToServer((Object)new TerrasteelCreateBurstMesssage());
        }
    }

    private void attackEntity(AttackEntityEvent evt) {
        if (!evt.getPlayer().field_70170_p.field_72995_K) {
            this.trySpawnBurst(evt.getPlayer());
        }
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int mana : CREATIVE_MANA) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemTerraSteelAIOT.setMana(stack, mana);
                list.add((Object)stack);
            }
            ItemStack stack = new ItemStack((IItemProvider)this);
            ItemTerraSteelAIOT.setMana(stack, CREATIVE_MANA[1]);
            ItemTerraSteelAIOT.setTipped(stack);
            list.add((Object)stack);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static boolean isTipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"tipped", (boolean)false);
    }

    public static void setTipped(ItemStack stack) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"tipped", (boolean)true);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"enabled", (boolean)false);
    }

    public static void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"enabled", (boolean)enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"mana", (int)mana);
    }

    public int getMana(ItemStack stack) {
        return ItemTerraSteelAIOT.getMana_(stack);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"mana", (int)0);
    }

    public static int getLevel(ItemStack stack) {
        int mana = ItemTerraSteelAIOT.getMana_(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    public int getMaxMana(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void addMana(ItemStack stack, int mana) {
        ItemTerraSteelAIOT.setMana(stack, Math.min(this.getMana(stack) + mana, Integer.MAX_VALUE));
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !otherStack.func_77973_b().func_206844_a((ITag)ModTags.Items.TERRA_PICK_BLACKLIST);
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    public boolean disposeOfTrashBlocks(ItemStack stack) {
        return ItemTerraSteelAIOT.isTipped(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack before, @Nonnull ItemStack after, boolean slotChanged) {
        return after.func_77973_b() != this || ItemTerraSteelAIOT.isEnabled(before) != ItemTerraSteelAIOT.isEnabled(after);
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        this.getMana(stack);
        int level = ItemTerraSteelAIOT.getLevel(stack);
        if (level != 0) {
            ItemTerraSteelAIOT.setEnabled(stack, !ItemTerraSteelAIOT.isEnabled(stack));
            if (!world.field_72995_K) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        World world;
        Material mat;
        if (ItemTerraSteelAIOT.isEnabled(stack) && MATERIALS.contains(mat = (world = player.field_70170_p).func_180495_p(pos).func_185904_a()) && !world.func_175623_d(pos)) {
            boolean thor = !ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b();
            boolean doX = thor || side.func_82601_c() == 0;
            boolean doY = thor || side.func_96559_d() == 0;
            boolean doZ = thor || side.func_82599_e() == 0;
            int origLevel = ItemTerraSteelAIOT.getLevel(stack);
            int level = origLevel + (thor ? 1 : 0);
            int rangeDepth = level / 2;
            if (ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player) && level > 2) {
                level = 2;
                rangeDepth = 0;
            }
            if (!(stack.func_77973_b() instanceof ItemAlfsteelAIOT)) {
                rangeDepth = 0;
            }
            int range = level - 1;
            int rangeY = Math.max(1, range);
            if (range != 0 || level == 1) {
                Vector3i beginDiff = new Vector3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
                Vector3i endDiff = new Vector3i(doX ? range : rangeDepth * -side.func_82601_c(), doY ? rangeY * 2 - 1 : 0, doZ ? range : rangeDepth * -side.func_82599_e());
                ToolCommons.removeBlocksInIteration((PlayerEntity)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vector3i)beginDiff, (Vector3i)endDiff, state -> stack.func_150997_a(state) > 1.0f || MATERIALS.contains(state.func_185904_a()));
                if (origLevel == 5) {
                    PlayerHelper.grantCriterion((ServerPlayerEntity)((ServerPlayerEntity)player), (ResourceLocation)ResourceLocationHelper.prefix((String)"challenge/rank_ss_pick"), (String)"code_triggered");
                }
            }
        }
    }

    public void breakOtherBlockAxe(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!player.func_225608_bj_() && !tickingSwappers && ItemTerraSteelAIOT.isEnabled(stack) && !ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player)) {
            ItemTerraSteelAIOT.addBlockSwapper(player.field_70170_p, player, stack, pos, 32, true);
        }
    }

    private void onTickEnd(TickEvent.WorldTickEvent event) {
        RegistryKey dim;
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && blockSwappers.containsKey(dim = event.world.func_234923_W_())) {
            tickingSwappers = true;
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
            tickingSwappers = false;
        }
    }

    private static void addBlockSwapper(World world, PlayerEntity player, ItemStack stack, BlockPos origCoords, int steps, boolean leaves) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, steps, leaves);
        if (!world.field_72995_K) {
            RegistryKey dim = world.func_234923_W_();
            blockSwappers.computeIfAbsent((RegistryKey<World>)dim, d -> new HashSet()).add(swapper);
        }
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<ITextComponent> list, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, list, flags);
        TranslationTextComponent rank = new TranslationTextComponent("botania.rank" + ItemTerraSteelAIOT.getLevel(stack));
        TranslationTextComponent rankFormat = new TranslationTextComponent("botaniamisc.toolRank", new Object[]{rank});
        list.add((ITextComponent)rankFormat);
        if (this.getMana(stack) == Integer.MAX_VALUE) {
            list.add((ITextComponent)new TranslationTextComponent("botaniamisc.getALife").func_240699_a_(TextFormatting.RED));
        }
    }

    public float getManaFractionForDisplay(ItemStack stack) {
        int level = ItemTerraSteelAIOT.getLevel(stack);
        if (level <= 0) {
            return (float)this.getMana(stack) / (float)LEVELS[1];
        }
        if (level >= LEVELS.length - 1) {
            return 1.0f;
        }
        return (float)(this.getMana(stack) - LEVELS[level]) / (float)LEVELS[level + 1];
    }

    @Override
    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        Direction side = ctx.func_196000_l();
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
        if (hoemode) {
            boolean thor = !ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b();
            int origLevel = ItemTerraSteelAIOT.getLevel(stack);
            int level = origLevel + (thor ? 1 : 0);
            if (ItemTemperanceStone.hasTemperanceActive((PlayerEntity)player) && level > 2) {
                level = 2;
            }
            int range = level - 1;
            if (!player.func_213453_ef()) {
                if (ItemTerraSteelAIOT.isEnabled(stack)) {
                    return ToolUtil.hoeUseAOE(ctx, this.special, false, range);
                }
                return ToolUtil.hoeUse(ctx, this.special, false);
            }
            if (side != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a())) {
                return ToolUtil.shovelUse(ctx);
            }
            return ToolUtil.stripLog(ctx);
        }
        if (!player.func_213453_ef()) {
            return ToolUtil.pickUse(ctx);
        }
        if (side == Direction.UP) {
            return ToolUtil.axeUse(ctx);
        }
        return ActionResultType.PASS;
    }

    private static class BlockSwapper {
        private final World world;
        private final PlayerEntity player;
        private final ItemStack truncator;
        private final boolean treatLeavesSpecial;
        private final PriorityQueue<SwapCandidate> candidateQueue;
        private final Set<BlockPos> completedCoords;

        public BlockSwapper(World world, PlayerEntity player, ItemStack truncator, BlockPos origCoords, int range, boolean leaves) {
            this.world = world;
            this.player = player;
            this.truncator = truncator;
            this.treatLeavesSpecial = leaves;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet<BlockPos>();
            this.candidateQueue.offer(new SwapCandidate(origCoords, range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 10;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                ToolCommons.removeBlockWithDrops((PlayerEntity)this.player, (ItemStack)this.truncator, (World)this.world, (BlockPos)cand.coordinates, state -> ToolCommons.materialsAxe.contains(state.func_185904_a()));
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    Block block = this.world.func_180495_p(adj).func_177230_c();
                    boolean isWood = BlockTags.field_200031_h.func_230235_a_((Object)block);
                    boolean isLeaf = BlockTags.field_206952_E.func_230235_a_((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(3, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.func_177982_a(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public static final class SwapCandidate
        implements Comparable<SwapCandidate> {
            public final BlockPos coordinates;
            public final int range;

            public SwapCandidate(BlockPos coordinates, int range) {
                this.coordinates = coordinates;
                this.range = range;
            }

            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }

            public boolean equals(Object other) {
                if (!(other instanceof SwapCandidate)) {
                    return false;
                }
                SwapCandidate cand = (SwapCandidate)other;
                return this.coordinates.equals((Object)cand.coordinates) && this.range == cand.range;
            }

            public int hashCode() {
                return Objects.hash(this.coordinates, this.range);
            }
        }
    }
}

