/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.terrasteel;

import de.melanx.aiotbotania.items.base.ItemShovelBase;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import de.melanx.aiotbotania.util.ToolBreakContext;
import de.melanx.aiotbotania.util.ToolUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemTerraShovel
extends ItemShovelBase
implements ISequentialBreaker {
    public ItemTerraShovel() {
        this(BotaniaAPI.instance().getTerrasteelItemTier());
    }

    public ItemTerraShovel(IItemTier mat) {
        super(mat, 3, -2.0f, 100);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack;
        ItemTerraSteelAIOT.setEnabled(stack, !ItemTerraSteelAIOT.isEnabled(stack = player.func_184586_b(hand)));
        if (!world.field_72995_K) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult raycast = ToolCommons.raytraceFromEntity((Entity)player, (double)10.0, (boolean)false);
        if (!player.field_70170_p.field_72995_K && raycast.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = raycast.func_216354_b();
            this.breakOtherBlock(player, stack, pos, pos, face);
            BotaniaAPI.instance().breakOnAllCursors(player, stack, pos, face);
        }
        return false;
    }

    public void breakOtherBlock(PlayerEntity player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (ItemTerraSteelAIOT.isEnabled(stack)) {
            World world = player.field_70170_p;
            BlockState state = world.func_180495_p(pos);
            if (stack.getToolTypes().stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) && !world.func_175623_d(pos)) {
                ToolUtil.removeBlocksInRange(new ToolBreakContext(player, pos, this.func_200891_e()), side, 1);
            }
        }
    }

    public boolean disposeOfTrashBlocks(ItemStack itemStack) {
        return false;
    }
}

