/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.alfsteel;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.compat.MythicBotany;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.alfsteel.ModPylonRepairable;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import vazkii.botania.common.entity.EntityManaBurst;

public class ItemAlfsteelAIOT
extends ItemTerraSteelAIOT
implements MythicBotany,
ModPylonRepairable {
    public static final int MANA_PER_DAMAGE = 200;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ItemAlfsteelAIOT() {
        super(ItemTiers.ALFSTEEL_AIOT_ITEM_TIER);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_234675_d_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (player.func_225608_bj_()) {
            double x = player.func_226277_ct_();
            double y = player.func_226278_cu_();
            double z = player.func_226281_cx_();
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(hand);
                stack.func_222118_a(1, (LivingEntity)player, _x -> {});
                player.func_184611_a(hand, stack);
            }
            int ITEM_COLLECT_RANGE = 8;
            List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)ITEM_COLLECT_RANGE, y - (double)ITEM_COLLECT_RANGE, z - (double)ITEM_COLLECT_RANGE, x + (double)ITEM_COLLECT_RANGE, y + (double)ITEM_COLLECT_RANGE, z + (double)ITEM_COLLECT_RANGE));
            for (ItemEntity item : items) {
                item.func_70012_b(x + (double)world.field_73012_v.nextFloat() - 0.5, y + (double)world.field_73012_v.nextFloat(), z + (double)world.field_73012_v.nextFloat() - 0.5, item.field_70177_z, item.field_70125_A);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public EntityManaBurst getBurst(PlayerEntity player, ItemStack stack) {
        EntityManaBurst burst = super.getBurst(player, stack);
        if (burst != null) {
            burst.setColor(16224512);
            burst.setMana(ItemAlfsteelAIOT.getManaPerDamage());
            burst.setStartingMana(ItemAlfsteelAIOT.getManaPerDamage());
            burst.setMinManaLoss(20);
            burst.setManaLossPerTick(2.0f);
        }
        return burst;
    }

    public static int getManaPerDamage() {
        return 200;
    }

    public float func_234675_d_() {
        return 12.0f;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return 500;
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.func_196085_b(Math.max(0, stack.func_77952_i() - 5));
        return stack;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (!ModList.get().isLoaded("mythicbotany")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("aiotbotania.mythicbotany.disabled").func_240699_a_(TextFormatting.DARK_RED));
        } else {
            super.func_77624_a(stack, world, tooltip, flag);
        }
    }
}

