/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.melanx.aiotbotania.AIOTBotania;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.client.core.helper.RenderHelper;

public class ContributorHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final Map<UUID, ItemStack> contributorMap = new HashMap<UUID, ItemStack>();
    private static boolean startedLoading = false;

    public ContributorHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        contributorMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            ItemStack stack = ContributorHandler.getItem(value);
            if (stack.func_190926_b()) {
                AIOTBotania.instance.getLogger().info("Oops, a wrong item at {}. Please report on GitHub. https://www.github.com/MelanX/aiotbotania/issues", (Object)key);
                continue;
            }
            UUID uuid = UUID.fromString(key);
            contributorMap.put(uuid, stack);
        }
    }

    private static ItemStack getItem(String id) {
        ResourceLocation location = new ResourceLocation("aiotbotania", id);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        return new ItemStack((IItemProvider)item);
    }

    private void renderIcon(MatrixStack ms, IRenderTypeBuffer buffers, PlayerEntity player, ItemStack stack) {
        ms.func_227860_a_();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        ms.func_227861_a_((double)0.15f, (double)-0.17f, (double)0.13f);
        ms.func_227862_a_(0.15f, 0.15f, 0.15f);
        if (player.func_213453_ef()) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
            ms.func_227861_a_(0.0, -1.76, 0.2);
        }
        RenderHelper.renderItemCustomColor((LivingEntity)player, (ItemStack)stack, (int)-1, (MatrixStack)ms, (IRenderTypeBuffer)buffers, (int)0xF000F0, (int)OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
    }

    public void render(MatrixStack ms, IRenderTypeBuffer buffers, int light, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (player.func_82150_aj()) {
            return;
        }
        ContributorHandler.firstStart();
        UUID uuid = player.func_146103_bH().getId();
        if (player.func_175148_a(PlayerModelPart.JACKET) && contributorMap.containsKey(uuid)) {
            this.renderIcon(ms, buffers, (PlayerEntity)player, contributorMap.get(uuid));
        }
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("AIOT Botania Contributor Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(AIOTBotania.instance.getLogger()));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://github.com/MelanX/mod-updatechecker-files/raw/master/contributors/aiotbotania.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorHandler.load(props);
                }
            }
            catch (IOException e) {
                AIOTBotania.instance.getLogger().info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

