/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeApiary.tileentity;

import com.YTrollman.CreativeApiary.config.CreativeApiaryConfig;
import com.YTrollman.CreativeApiary.container.CreativeApiaryBreederContainer;
import com.YTrollman.CreativeApiary.registry.ModTileEntityTypes;
import com.YTrollman.CreativeApiary.tileentity.CreativeApiaryStorageTileEntity;
import com.YTrollman.CreativeApiary.tileentity.CreativeApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.api.ICustomBee;
import com.resourcefulbees.resourcefulbees.api.beedata.BreedData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.item.UpgradeItem;
import com.resourcefulbees.resourcefulbees.lib.ApiaryTabs;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.IApiaryMultiblock;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CreativeApiaryBreederTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
IApiaryMultiblock {
    private static final int[] PARENT_1_SLOTS = new int[]{4, 9, 14, 19, 24};
    private static final int[] FEED_1_SLOTS = new int[]{5, 10, 15, 20, 25};
    private static final int[] PARENT_2_SLOTS = new int[]{6, 11, 16, 21, 26};
    private static final int[] FEED_2_SLOTS = new int[]{7, 12, 17, 22, 27};
    private static final int[] EMPTY_JAR_SLOTS = new int[]{8, 13, 18, 23, 28};
    private final TileStackHandler tileStackHandler = new TileStackHandler(29);
    private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(this::getTileStackHandler);
    private int[] time = new int[]{0, 0, 0, 0, 0};
    private int totalTime = (int)((double)((Integer)Config.APIARY_MAX_BREED_TIME.get()).intValue() * (1.0 - (Double)CreativeApiaryConfig.CREATIVE_APIARY_BREEDER_SPEED.get()));
    private int numberOfBreeders = 5;
    private BlockPos apiaryPos;
    private CreativeApiaryTileEntity apiary;
    protected final IIntArray times = new IIntArray(){

        public int func_221476_a(int index) {
            return MathUtils.inRangeExclusive((int)index, (int)-1, (int)5) ? CreativeApiaryBreederTileEntity.this.getTime()[index] : 0;
        }

        public void func_221477_a(int index, int value) {
            if (!MathUtils.inRangeExclusive((int)index, (int)-1, (int)5)) {
                return;
            }
            CreativeApiaryBreederTileEntity.this.getTime()[index] = value;
        }

        public int func_221478_a() {
            return 5;
        }
    };

    public CreativeApiaryBreederTileEntity() {
        super((TileEntityType)ModTileEntityTypes.CREATIVE_APIARY_BREEDER_TILE_ENTITY.get());
    }

    public static int[] getParent1Slots() {
        return PARENT_1_SLOTS;
    }

    public static int[] getFeed1Slots() {
        return FEED_1_SLOTS;
    }

    public static int[] getParent2Slots() {
        return PARENT_2_SLOTS;
    }

    public static int[] getFeed2Slots() {
        return FEED_2_SLOTS;
    }

    public static int[] getEmptyJarSlots() {
        return EMPTY_JAR_SLOTS;
    }

    public BlockPos getApiaryPos() {
        return this.apiaryPos;
    }

    public void setApiaryPos(BlockPos apiaryPos) {
        this.apiaryPos = apiaryPos;
    }

    public CreativeApiaryTileEntity getApiary() {
        TileEntity tile;
        if (this.apiaryPos != null && this.field_145850_b != null && (tile = this.field_145850_b.func_175625_s(this.apiaryPos)) instanceof CreativeApiaryTileEntity) {
            return (CreativeApiaryTileEntity)tile;
        }
        return null;
    }

    public boolean validateApiaryLink() {
        this.apiary = this.getApiary();
        if (this.apiary == null || this.apiary.getBreederPos() == null || !this.apiary.getBreederPos().equals((Object)this.func_174877_v()) || !this.apiary.isValidApiary(false)) {
            this.apiaryPos = null;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.validateApiaryLink();
            boolean dirty = false;
            for (int i = 0; i < this.getNumberOfBreeders(); ++i) {
                if (!(this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent1Slots()[i]).func_190926_b() || this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed1Slots()[i]).func_190926_b() || this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent2Slots()[i]).func_190926_b() || this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed2Slots()[i]).func_190926_b() || this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getEmptyJarSlots()[i]).func_190926_b())) {
                    if (this.canProcess(i)) {
                        int[] nArray = this.getTime();
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        if (this.getTime()[i] >= this.getTotalTime()) {
                            this.getTime()[i] = 0;
                            this.processBreed(i);
                            dirty = true;
                        }
                    }
                } else {
                    this.getTime()[i] = 0;
                }
                if (!dirty) continue;
                this.func_70296_d();
            }
        }
    }

    protected boolean canProcess(int slot) {
        ItemStack p1Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent1Slots()[slot]);
        ItemStack p2Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent2Slots()[slot]);
        if (p1Stack.func_77973_b() instanceof BeeJar && p2Stack.func_77973_b() instanceof BeeJar) {
            BeeJar p1Jar = (BeeJar)p1Stack.func_77973_b();
            BeeJar p2Jar = (BeeJar)p2Stack.func_77973_b();
            Entity p1Entity = BeeJar.getEntityFromStack((ItemStack)p1Stack, (World)this.field_145850_b, (boolean)true);
            Entity p2Entity = BeeJar.getEntityFromStack((ItemStack)p2Stack, (World)this.field_145850_b, (boolean)true);
            if (p1Entity instanceof CustomBeeEntity && p2Entity instanceof CustomBeeEntity) {
                String p1Type = ((CustomBeeEntity)p1Entity).getBeeData().getName();
                String p2Type = ((CustomBeeEntity)p2Entity).getBeeData().getName();
                boolean canBreed = BeeRegistry.getRegistry().canParentsBreed(p1Type, p2Type);
                ItemStack f1Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed1Slots()[slot]);
                ItemStack f2Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed2Slots()[slot]);
                BreedData p1BreedData = ((CustomBeeEntity)p1Entity).getBeeData().getBreedData();
                BreedData p2BreedData = ((CustomBeeEntity)p2Entity).getBeeData().getBreedData();
                int f1StackCount = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed1Slots()[slot]).func_190916_E();
                int f2StackCount = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed2Slots()[slot]).func_190916_E();
                int p1FeedAmount = ((CustomBeeEntity)p1Entity).getBeeData().getBreedData().getFeedAmount();
                int p2FeedAmount = ((CustomBeeEntity)p2Entity).getBeeData().getBreedData().getFeedAmount();
                return canBreed && BeeInfoUtils.isValidBreedItem((ItemStack)f1Stack, (BreedData)p1BreedData) && BeeInfoUtils.isValidBreedItem((ItemStack)f2Stack, (BreedData)p2BreedData) && f1StackCount >= p1FeedAmount && f2StackCount >= p2FeedAmount && !this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getEmptyJarSlots()[slot]).func_190926_b();
            }
        }
        return false;
    }

    private void processBreed(int slot) {
        if (this.canProcess(slot)) {
            ItemStack p1Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent1Slots()[slot]);
            ItemStack p2Stack = this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getParent2Slots()[slot]);
            if (p1Stack.func_77973_b() instanceof BeeJar && p2Stack.func_77973_b() instanceof BeeJar) {
                BeeJar p1Jar = (BeeJar)p1Stack.func_77973_b();
                BeeJar p2Jar = (BeeJar)p2Stack.func_77973_b();
                Entity p1Entity = BeeJar.getEntityFromStack((ItemStack)p1Stack, (World)this.field_145850_b, (boolean)true);
                Entity p2Entity = BeeJar.getEntityFromStack((ItemStack)p2Stack, (World)this.field_145850_b, (boolean)true);
                if (p1Entity instanceof ICustomBee && p2Entity instanceof ICustomBee) {
                    CreativeApiaryStorageTileEntity apiaryStorage;
                    TileEntity tile;
                    ICustomBee bee1 = (ICustomBee)p1Entity;
                    ICustomBee bee2 = (ICustomBee)p2Entity;
                    String p1Type = bee1.getBeeData().getName();
                    String p2Type = bee2.getBeeData().getName();
                    if (this.field_145850_b != null && this.validateApiaryLink() && (tile = this.field_145850_b.func_175625_s(this.apiary.getStoragePos())) instanceof CreativeApiaryStorageTileEntity && (apiaryStorage = (CreativeApiaryStorageTileEntity)tile).breedComplete(p1Type, p2Type)) {
                        this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getEmptyJarSlots()[slot]).func_190918_g(1);
                        this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed1Slots()[slot]).func_190918_g(bee1.getBeeData().getBreedData().getFeedAmount());
                        this.getTileStackHandler().getStackInSlot(CreativeApiaryBreederTileEntity.getFeed2Slots()[slot]).func_190918_g(bee2.getBeeData().getBreedData().getFeedAmount());
                    }
                }
            }
        }
        this.getTime()[slot] = 0;
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        return this.saveToNBT(nbt);
    }

    public CompoundNBT saveToNBT(CompoundNBT nbt) {
        CompoundNBT inv = this.getTileStackHandler().serializeNBT();
        nbt.func_218657_a("inv", (INBT)inv);
        nbt.func_74783_a("time", this.getTime());
        nbt.func_74768_a("totalTime", this.getTotalTime());
        if (this.apiaryPos != null) {
            nbt.func_218657_a("ApiaryPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.apiaryPos));
        }
        if (this.getNumberOfBreeders() != 1) {
            nbt.func_74768_a("BreederCount", this.getNumberOfBreeders());
        }
        return nbt;
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromNBT(nbt);
    }

    public void loadFromNBT(CompoundNBT nbt) {
        CompoundNBT invTag = nbt.func_74775_l("inv");
        this.getTileStackHandler().deserializeNBT(invTag);
        this.setTime(nbt.func_74759_k("time"));
        this.setTotalTime(nbt.func_74762_e("totalTime"));
        if (nbt.func_74764_b("ApiaryPos")) {
            this.apiaryPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("ApiaryPos"));
        }
        if (nbt.func_74764_b("BreederCount")) {
            this.setNumberOfBreeders(nbt.func_74762_e("BreederCount"));
        }
    }

    public void handleUpdateTag(@NotNull BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.saveToNBT(nbt));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.loadFromNBT(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.lazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || slot > 3;
    }

    public AutomationSensitiveItemStackHandler.IRemover getRemover() {
        return (slot, automation) -> !automation || slot > 3;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        return new CreativeApiaryBreederContainer(id, this.field_145850_b, this.field_174879_c, playerInventory, this.times);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.creativeapiary.creative_apiary_breeder");
    }

    public void switchTab(ServerPlayerEntity player, ApiaryTabs tab) {
        if (this.field_145850_b != null && this.apiaryPos != null) {
            TileEntity tile;
            if (tab == ApiaryTabs.MAIN) {
                tile = this.field_145850_b.func_175625_s(this.apiaryPos);
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)this.apiaryPos);
            }
            if (tab == ApiaryTabs.STORAGE) {
                tile = this.field_145850_b.func_175625_s(this.apiary.getStoragePos());
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)this.apiary.getStoragePos());
            }
        }
    }

    public int[] getTime() {
        return this.time;
    }

    public void setTime(int[] time) {
        this.time = time;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(int totalTime) {
        this.totalTime = totalTime;
    }

    public int getNumberOfBreeders() {
        return this.numberOfBreeders;
    }

    public void setNumberOfBreeders(int numberOfBreeders) {
        this.numberOfBreeders = numberOfBreeders;
    }

    @NotNull
    public TileStackHandler getTileStackHandler() {
        return this.tileStackHandler;
    }

    public class TileStackHandler
    extends AutomationSensitiveItemStackHandler {
        private int maxSlots;

        public void setMaxSlots(int maxSlots) {
            this.maxSlots = maxSlots;
        }

        protected TileStackHandler(int slots) {
            super(slots);
            this.maxSlots = 28;
        }

        public AutomationSensitiveItemStackHandler.IAcceptor getAcceptor() {
            return CreativeApiaryBreederTileEntity.this.getAcceptor();
        }

        public AutomationSensitiveItemStackHandler.IRemover getRemover() {
            return CreativeApiaryBreederTileEntity.this.getRemover();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CreativeApiaryBreederTileEntity.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 19: 
                case 21: 
                case 24: 
                case 26: {
                    return 1;
                }
            }
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return UpgradeItem.hasUpgradeData((ItemStack)stack) && UpgradeItem.getUpgradeType((ItemStack)stack).contains("Breeder");
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 19: 
                case 21: 
                case 24: 
                case 26: {
                    return this.isSlotVisible(slot) && BeeInfoUtils.isBeeInJarOurs((ItemStack)stack);
                }
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 15: 
                case 17: 
                case 20: 
                case 22: 
                case 25: 
                case 27: {
                    return this.isSlotVisible(slot) && !(stack.func_77973_b() instanceof BeeJar);
                }
                case 8: 
                case 13: 
                case 18: 
                case 23: 
                case 28: {
                    return this.isSlotVisible(slot) && stack.func_77973_b() instanceof BeeJar && !BeeJar.isFilled((ItemStack)stack);
                }
            }
            return false;
        }

        private boolean isSlotVisible(int slot) {
            return slot <= this.maxSlots;
        }
    }
}

