/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeApiary.network;

import com.YTrollman.CreativeApiary.tileentity.CreativeApiaryTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class CreativeBuildApiaryMessage {
    private final BlockPos pos;
    private final int verticalOffset;
    private final int horizontalOffset;

    public CreativeBuildApiaryMessage(BlockPos pos, int verticalOffset, int horizontalOffset) {
        this.pos = pos;
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
    }

    public static void encode(CreativeBuildApiaryMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeInt(message.verticalOffset);
        buffer.writeInt(message.horizontalOffset);
    }

    public static CreativeBuildApiaryMessage decode(PacketBuffer buffer) {
        return new CreativeBuildApiaryMessage(buffer.func_179259_c(), buffer.readInt(), buffer.readInt());
    }

    public static void handle(CreativeBuildApiaryMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && player.field_70170_p.func_195588_v(message.pos) && (tileEntity = player.field_70170_p.func_175625_s(message.pos)) instanceof CreativeApiaryTileEntity) {
                CreativeApiaryTileEntity apiaryTileEntity = (CreativeApiaryTileEntity)tileEntity;
                apiaryTileEntity.setVerticalOffset(message.verticalOffset);
                apiaryTileEntity.setHorizontalOffset(message.horizontalOffset);
                apiaryTileEntity.runCreativeBuild(player);
            }
        });
        context.get().setPacketHandled(true);
    }
}

