/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.AutomationType;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalUtil {
    private ChemicalUtil() {
    }

    public static <HANDLER extends IChemicalHandler<?, ?>> Capability<HANDLER> getCapabilityForChemical(Chemical<?> chemical) {
        if (chemical instanceof Gas) {
            return Capabilities.GAS_HANDLER_CAPABILITY;
        }
        if (chemical instanceof InfuseType) {
            return Capabilities.INFUSION_HANDLER_CAPABILITY;
        }
        if (chemical instanceof Pigment) {
            return Capabilities.PIGMENT_HANDLER_CAPABILITY;
        }
        if (chemical instanceof Slurry) {
            return Capabilities.SLURRY_HANDLER_CAPABILITY;
        }
        throw new IllegalStateException("Unknown Chemical Type: " + chemical.getClass().getName());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> Capability<HANDLER> getCapabilityForChemical(STACK stack) {
        return ChemicalUtil.getCapabilityForChemical(stack.getType());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> Capability<HANDLER> getCapabilityForChemical(IChemicalTank<CHEMICAL, STACK> tank) {
        return ChemicalUtil.getCapabilityForChemical(tank.getEmptyStack());
    }

    public static <STACK extends ChemicalStack<?>> STACK getEmptyStack(STACK stack) {
        if (stack instanceof GasStack) {
            return (STACK)GasStack.EMPTY;
        }
        if (stack instanceof InfusionStack) {
            return (STACK)InfusionStack.EMPTY;
        }
        if (stack instanceof PigmentStack) {
            return (STACK)PigmentStack.EMPTY;
        }
        if (stack instanceof SlurryStack) {
            return (STACK)SlurryStack.EMPTY;
        }
        throw new IllegalStateException("Unknown Chemical Type: " + stack.getType().getClass().getName());
    }

    public static boolean compareTypes(ChemicalType chemicalType, MergedChemicalTank.Current current) {
        switch (chemicalType) {
            case GAS: {
                return current == MergedChemicalTank.Current.GAS;
            }
            case INFUSION: {
                return current == MergedChemicalTank.Current.INFUSION;
            }
            case PIGMENT: {
                return current == MergedChemicalTank.Current.PIGMENT;
            }
            case SLURRY: {
                return current == MergedChemicalTank.Current.SLURRY;
            }
        }
        throw new IllegalStateException("Unknown Chemical Type");
    }

    public static <STACK extends ChemicalStack<?>> STACK copy(STACK stack) {
        return (STACK)stack.copy();
    }

    public static <STACK extends ChemicalStack<?>> STACK copyWithAmount(STACK stack, long amount) {
        if (stack instanceof GasStack) {
            return (STACK)new GasStack((GasStack)stack, amount);
        }
        if (stack instanceof InfusionStack) {
            return (STACK)new InfusionStack((InfusionStack)stack, amount);
        }
        if (stack instanceof PigmentStack) {
            return (STACK)new PigmentStack((PigmentStack)stack, amount);
        }
        if (stack instanceof SlurryStack) {
            return (STACK)new SlurryStack((SlurryStack)stack, amount);
        }
        throw new IllegalStateException("Unknown Chemical Type: " + stack.getType().getClass().getName());
    }

    public static ItemStack getFullChemicalTank(ChemicalTankTier tier, @Nonnull Chemical<?> chemical) {
        return ChemicalUtil.getFilledVariant(ChemicalUtil.getEmptyChemicalTank(tier), tier.getStorage(), chemical);
    }

    private static ItemStack getEmptyChemicalTank(ChemicalTankTier tier) {
        switch (tier) {
            case BASIC: {
                return MekanismBlocks.BASIC_CHEMICAL_TANK.getItemStack();
            }
            case ADVANCED: {
                return MekanismBlocks.ADVANCED_CHEMICAL_TANK.getItemStack();
            }
            case ELITE: {
                return MekanismBlocks.ELITE_CHEMICAL_TANK.getItemStack();
            }
            case ULTIMATE: {
                return MekanismBlocks.ULTIMATE_CHEMICAL_TANK.getItemStack();
            }
            case CREATIVE: {
                return MekanismBlocks.CREATIVE_CHEMICAL_TANK.getItemStack();
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFilledVariant(ItemStack toFill, long capacity, IChemicalProvider<?> provider) {
        if (provider instanceof IGasProvider) {
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.GAS, capacity, (IGasProvider)provider, "GasTanks");
        }
        if (provider instanceof IInfuseTypeProvider) {
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.INFUSION, capacity, (IInfuseTypeProvider)provider, "InfusionTanks");
        }
        if (provider instanceof IPigmentProvider) {
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.PIGMENT, capacity, (IPigmentProvider)provider, "PigmentTanks");
        }
        if (provider instanceof ISlurryProvider) {
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.SLURRY, capacity, (ISlurryProvider)provider, "SlurryTanks");
        }
        throw new IllegalStateException("Unknown Chemical Type: " + provider.getChemical().getClass().getName());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> ItemStack getFilledVariant(ItemStack toFill, ChemicalTankBuilder<CHEMICAL, STACK, TANK> tankBuilder, long capacity, IChemicalProvider<CHEMICAL> provider, String key) {
        TANK dummyTank = tankBuilder.createDummy(capacity);
        dummyTank.setStack(provider.getStack(dummyTank.getCapacity()));
        ItemDataUtils.setList(toFill, key, DataHandlerUtils.writeContainers(Collections.singletonList(dummyTank)));
        return toFill;
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        if (!gasStack.isEmpty()) {
            return gasStack.getChemicalColorRepresentation();
        }
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        if (!infusionStack.isEmpty()) {
            return infusionStack.getChemicalColorRepresentation();
        }
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromNBT(stack);
        if (!pigmentStack.isEmpty()) {
            return pigmentStack.getChemicalColorRepresentation();
        }
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromNBT(stack);
        if (!slurryStack.isEmpty()) {
            return slurryStack.getChemicalColorRepresentation();
        }
        return 0;
    }

    public static boolean hasGas(ItemStack stack) {
        return ChemicalUtil.hasChemical(stack, s -> true, Capabilities.GAS_HANDLER_CAPABILITY);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean hasChemical(ItemStack stack, CHEMICAL type) {
        Capability capability = ChemicalUtil.getCapabilityForChemical(type);
        return ChemicalUtil.hasChemical(stack, s -> s.isTypeEqual(type), capability);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean hasChemical(ItemStack stack, Predicate<STACK> validityCheck, Capability<HANDLER> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalStack).isEmpty() || !validityCheck.test(chemicalStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAttributeTooltips(List<ITextComponent> tooltips, Chemical<?> chemical) {
        chemical.getAttributes().forEach(attr -> attr.addTooltipText(tooltips));
    }

    public static void addChemicalDataToTooltip(List<ITextComponent> tooltips, Chemical<?> chemical, boolean advanced) {
        if (!chemical.isEmptyType()) {
            ChemicalUtil.addAttributeTooltips(tooltips, chemical);
            if (chemical instanceof Gas && ((Gas)chemical).isIn(MekanismTags.Gases.WASTE_BARREL_DECAY_BLACKLIST)) {
                tooltips.add((ITextComponent)MekanismLang.DECAY_IMMUNE.translateColored(EnumColor.AQUA, new Object[0]));
            }
            if (advanced) {
                tooltips.add((ITextComponent)TextComponentUtil.build(TextFormatting.DARK_GRAY, chemical.getRegistryName()));
            }
        }
    }

    public static void emit(IChemicalTank<?, ?> tank, TileEntity from) {
        ChemicalUtil.emit(EnumSet.allOf(Direction.class), tank, from);
    }

    public static void emit(Set<Direction> outputSides, IChemicalTank<?, ?> tank, TileEntity from) {
        ChemicalUtil.emit(outputSides, tank, from, tank.getCapacity());
    }

    public static void emit(Set<Direction> outputSides, IChemicalTank<?, ?> tank, TileEntity from, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(ChemicalUtil.emit(outputSides, tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> long emit(Set<Direction> sides, @Nonnull STACK stack, TileEntity from) {
        if (stack.isEmpty() || sides.isEmpty()) {
            return 0L;
        }
        Capability capability = ChemicalUtil.getCapabilityForChemical(stack);
        ChemicalHandlerTarget target = new ChemicalHandlerTarget(stack, 6);
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> CapabilityUtils.getCapability((ICapabilityProvider)acceptor, capability, side.func_176734_d()).ifPresent(handler -> {
            if (ChemicalUtil.canInsert(handler, stack)) {
                target.addHandler(handler);
            }
        }));
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, stack.getAmount(), ChemicalUtil.copy(stack));
        }
        return 0L;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean canInsert(HANDLER handler, @Nonnull STACK stack) {
        return ((ChemicalStack)handler.insertChemical(stack, Action.SIMULATE)).getAmount() < stack.getAmount();
    }
}

