/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.EnumSet;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public final class CableUtils {
    private CableUtils() {
    }

    public static void emit(IEnergyContainer energyContainer, TileEntity from) {
        CableUtils.emit(EnumSet.allOf(Direction.class), energyContainer, from);
    }

    public static void emit(Set<Direction> outputSides, IEnergyContainer energyContainer, TileEntity from) {
        CableUtils.emit(outputSides, energyContainer, from, energyContainer.getMaxEnergy());
    }

    public static void emit(Set<Direction> outputSides, IEnergyContainer energyContainer, TileEntity from, FloatingLong maxOutput) {
        if (!energyContainer.isEmpty() && !maxOutput.isZero()) {
            energyContainer.extract(CableUtils.emit(outputSides, energyContainer.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static FloatingLong emit(Set<Direction> sides, FloatingLong energyToSend, TileEntity from) {
        if (energyToSend.isZero() || sides.isEmpty()) {
            return FloatingLong.ZERO;
        }
        EnergyAcceptorTarget target = new EnergyAcceptorTarget(6);
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> EnergyCompatUtils.getLazyStrictEnergyHandler(acceptor, side.func_176734_d()).ifPresent(target::addHandler));
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, energyToSend);
        }
        return FloatingLong.ZERO;
    }
}

