/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.fluid.DynamicFluidHandler;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter
implements IComputerTile {
    private final FluidHandlerManager fluidHandlerManager = new FluidHandlerManager(direction -> {
        MechanicalPipe pipe = this.getTransmitter();
        if (direction != null && pipe.getConnectionTypeRaw(direction) == ConnectionType.NONE) {
            return Collections.emptyList();
        }
        return pipe.getFluidTanks(direction);
    }, new DynamicFluidHandler(this::getFluidTanks, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityMechanicalPipe(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(this.fluidHandlerManager);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(this, this::addCapabilityResolver);
        }
    }

    protected MechanicalPipe createTransmitter(IBlockProvider blockProvider) {
        return new MechanicalPipe(blockProvider, this);
    }

    public MechanicalPipe getTransmitter() {
        return (MechanicalPipe)super.getTransmitter();
    }

    @Override
    public void func_73660_a() {
        if (!this.isRemote()) {
            this.getTransmitter().pullFromAcceptors();
        }
        super.func_73660_a();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_MECHANICAL_PIPE);
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_MECHANICAL_PIPE);
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_MECHANICAL_PIPE);
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_MECHANICAL_PIPE);
            }
        }
        return current;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.func_218657_a("fluid", (INBT)network.lastFluid.writeToNBT(new CompoundNBT()));
            updateTag.func_74776_a("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@Nonnull Direction side, @Nonnull ConnectionType old, @Nonnull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            WorldUtils.notifyNeighborOfChange(this.field_145850_b, side, this.field_174879_c);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange(this.field_145850_b, side, this.field_174879_c);
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "MechanicalPipe";
    }

    @ComputerMethod
    private FluidStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    private long getCapacity() {
        MechanicalPipe pipe = this.getTransmitter();
        return pipe.hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitterNetwork()).getCapacity() : pipe.getCapacity();
    }

    @ComputerMethod
    private long getNeeded() {
        return this.getCapacity() - (long)this.getBuffer().getAmount();
    }

    @ComputerMethod
    private double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

