/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.lib.collection.HashList;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class TileEntityQIOFilterHandler
extends TileEntityQIOComponent
implements ITileFilterHolder<QIOFilter<?>>,
IHasSortableFilters,
ISustainedData {
    private HashList<QIOFilter<?>> filters = new HashList();

    public TileEntityQIOFilterHandler(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    @ComputerMethod
    public HashList<QIOFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof QIOFilter)) continue;
                this.filters.add((QIOFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            data.func_218657_a("filters", (INBT)filterTags);
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        this.filters.clear();
        if (data.func_150297_b("filters", 9)) {
            ListNBT tagList = data.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof QIOFilter)) continue;
                this.filters.add((QIOFilter)filter);
            }
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    protected int getMaxTransitCount() {
        return 64 + 32 * this.upgradeComponent.getUpgrades(Upgrade.SPEED);
    }

    protected int getMaxTransitTypes() {
        return Math.round(1.0f + (float)this.upgradeComponent.getUpgrades(Upgrade.SPEED) / 2.0f);
    }

    @ComputerMethod
    private boolean addFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.remove(filter);
    }
}

