/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.FluidUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDynamicTank
extends TileEntityMultiblock<TankMultiblockData>
implements IFluidContainerManager {
    public TileEntityDynamicTank() {
        this(MekanismBlocks.DYNAMIC_TANK);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public TileEntityDynamicTank(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        TankMultiblockData multiblock;
        if (!player.func_225608_bj_() && (multiblock = (TankMultiblockData)this.getMultiblock()).isFormed()) {
            if (this.manageInventory(multiblock, player, hand, stack)) {
                player.field_71071_by.func_70296_d();
                return ActionResultType.SUCCESS;
            }
            return this.openGui(player);
        }
        return ActionResultType.PASS;
    }

    @Override
    @Nonnull
    public TankMultiblockData createMultiblock() {
        return new TankMultiblockData(this);
    }

    @Override
    public MultiblockManager<TankMultiblockData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public IFluidContainerManager.ContainerEditMode getContainerEditMode() {
        return ((TankMultiblockData)this.getMultiblock()).editMode;
    }

    @Override
    public void nextMode() {
        TankMultiblockData multiblock = (TankMultiblockData)this.getMultiblock();
        multiblock.setContainerEditMode((IFluidContainerManager.ContainerEditMode)multiblock.editMode.getNext());
    }

    private boolean manageInventory(TankMultiblockData multiblock, PlayerEntity player, Hand hand, ItemStack itemStack) {
        if (multiblock.isFormed()) {
            return FluidUtils.handleTankInteraction(player, hand, itemStack, multiblock.getFluidTank());
        }
        return false;
    }
}

