/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;

public class TileEntitySeismicVibrator
extends TileEntityMekanism
implements IBoundingBlock {
    public int clientPiston;
    private MachineEnergyContainer<TileEntitySeismicVibrator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntitySeismicVibrator() {
        super(MekanismBlocks.SEISMIC_VIBRATOR);
        this.cacheCoord();
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntitySeismicVibrator)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            ++this.clientPiston;
        }
        this.updateActiveVibrators();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this)) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.updateActiveVibrators();
    }

    private void updateActiveVibrators() {
        if (this.getActive()) {
            Mekanism.activeVibrators.add(this.getTileCoord());
        } else {
            Mekanism.activeVibrators.remove(this.getTileCoord());
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        Mekanism.activeVibrators.remove(this.getTileCoord());
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
        }
    }

    @Override
    public void onPlace() {
        super.onPlace();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public MachineEnergyContainer<TileEntitySeismicVibrator> getEnergyContainer() {
        return this.energyContainer;
    }
}

