/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config.slot;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.HeatSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;

public interface IProxiedSlotInfo
extends ISlotInfo {

    @FunctionalInterface
    public static interface ProxySlotInfoCreator<T> {
        public IProxiedSlotInfo create(boolean var1, boolean var2, Supplier<List<T>> var3);
    }

    public static class InventoryProxy
    extends InventorySlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IInventorySlot>> slotSupplier;

        public InventoryProxy(boolean canInput, boolean canOutput, Supplier<List<IInventorySlot>> slotSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.slotSupplier = slotSupplier;
        }

        @Override
        public List<IInventorySlot> getSlots() {
            return this.slotSupplier.get();
        }
    }

    public static class HeatProxy
    extends HeatSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IHeatCapacitor>> capacitorSupplier;

        public HeatProxy(boolean canInput, boolean canOutput, Supplier<List<IHeatCapacitor>> capacitorSupplier) {
            super(canInput, canOutput, new IHeatCapacitor[0]);
            this.capacitorSupplier = capacitorSupplier;
        }

        @Override
        public List<IHeatCapacitor> getHeatCapacitors() {
            return this.capacitorSupplier.get();
        }
    }

    public static class SlurryProxy
    extends ChemicalSlotInfo.SlurrySlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<ISlurryTank>> tankSupplier;

        public SlurryProxy(boolean canInput, boolean canOutput, Supplier<List<ISlurryTank>> tankSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<ISlurryTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class PigmentProxy
    extends ChemicalSlotInfo.PigmentSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IPigmentTank>> tankSupplier;

        public PigmentProxy(boolean canInput, boolean canOutput, Supplier<List<IPigmentTank>> tankSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IPigmentTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class InfusionProxy
    extends ChemicalSlotInfo.InfusionSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IInfusionTank>> tankSupplier;

        public InfusionProxy(boolean canInput, boolean canOutput, Supplier<List<IInfusionTank>> tankSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IInfusionTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class GasProxy
    extends ChemicalSlotInfo.GasSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IGasTank>> tankSupplier;

        public GasProxy(boolean canInput, boolean canOutput, Supplier<List<IGasTank>> tankSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IGasTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class FluidProxy
    extends FluidSlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IExtendedFluidTank>> tankSupplier;

        public FluidProxy(boolean canInput, boolean canOutput, Supplier<List<IExtendedFluidTank>> tankSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.tankSupplier = tankSupplier;
        }

        @Override
        public List<IExtendedFluidTank> getTanks() {
            return this.tankSupplier.get();
        }
    }

    public static class EnergyProxy
    extends EnergySlotInfo
    implements IProxiedSlotInfo {
        private final Supplier<List<IEnergyContainer>> containerSupplier;

        public EnergyProxy(boolean canInput, boolean canOutput, Supplier<List<IEnergyContainer>> containerSupplier) {
            super(canInput, canOutput, Collections.emptyList());
            this.containerSupplier = containerSupplier;
        }

        @Override
        public List<IEnergyContainer> getContainers() {
            return this.containerSupplier.get();
        }
    }
}

