/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityBoundingBlock
extends TileEntityUpdateable
implements IUpgradeTile,
ISecurityTile {
    private BlockPos mainPos = BlockPos.field_177992_a;
    public boolean receivedCoords;
    private int currentRedstoneLevel;

    public TileEntityBoundingBlock() {
        this(MekanismTileEntityTypes.BOUNDING_BLOCK.getTileEntityType());
    }

    public TileEntityBoundingBlock(TileEntityType<TileEntityBoundingBlock> type) {
        super(type);
    }

    public void setMainLocation(BlockPos pos) {
        boolean bl = this.receivedCoords = pos != null;
        if (!this.isRemote()) {
            this.mainPos = pos;
            this.sendUpdatePacket();
        }
    }

    public BlockPos getMainPos() {
        if (this.mainPos == null) {
            this.mainPos = BlockPos.field_177992_a;
        }
        return this.mainPos;
    }

    @Nullable
    public TileEntity getMainTile() {
        return this.receivedCoords ? WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, this.getMainPos()) : null;
    }

    @Nullable
    private IBoundingBlock getMain() {
        TileEntity tile = this.getMainTile();
        if (tile != null && !(tile instanceof IBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IBoundingBlock, at {}. Multiblock cannot function", (Object)tile, (Object)this.getMainPos());
            return null;
        }
        return (IBoundingBlock)tile;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        IBoundingBlock main = this.getMain();
        if (main == null) {
            return super.getCapability(capability, side);
        }
        return main.getOffsetCapability(capability, side, (Vector3i)this.field_174879_c.func_177973_b((Vector3i)this.getMainPos()));
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        int power;
        if (!this.isRemote() && this.currentRedstoneLevel != (power = this.field_145850_b.func_175687_A(this.func_174877_v()))) {
            IBoundingBlock main = this.getMain();
            if (main != null) {
                main.onBoundingBlockPowerChange(this.field_174879_c, this.currentRedstoneLevel, power);
            }
            this.currentRedstoneLevel = power;
        }
    }

    public int getComparatorSignal() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsComparator()) {
            return main.getBoundingComparatorSignal((Vector3i)this.field_174879_c.func_177973_b((Vector3i)this.getMainPos()));
        }
        return 0;
    }

    @Override
    public boolean supportsUpgrades() {
        IBoundingBlock main = this.getMain();
        return main != null && main.supportsUpgrades();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            return main.getComponent();
        }
        return null;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgradeType) {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            main.recalculateUpgrades(upgradeType);
        }
    }

    @Override
    public boolean hasSecurity() {
        IBoundingBlock main = this.getMain();
        return main != null && main.hasSecurity();
    }

    @Override
    public TileComponentSecurity getSecurity() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.hasSecurity()) {
            return main.getSecurity();
        }
        return null;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setBlockPosIfPresent(nbtTags, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = nbtTags.func_74762_e("redstone");
        this.receivedCoords = nbtTags.func_74767_n("receivedCoords");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        nbtTags.func_74768_a("redstone", this.currentRedstoneLevel);
        nbtTags.func_74757_a("receivedCoords", this.receivedCoords);
        return nbtTags;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        updateTag.func_74768_a("redstone", this.currentRedstoneLevel);
        updateTag.func_74757_a("receivedCoords", this.receivedCoords);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setBlockPosIfPresent(tag, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = tag.func_74762_e("redstone");
        this.receivedCoords = tag.func_74767_n("receivedCoords");
    }
}

