/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.registries.MekanismRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MekanismShapedRecipe
extends WrappedShapedRecipe {
    public MekanismShapedRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return MekanismRecipeSerializers.MEK_DATA.getRecipeSerializer();
    }

    @Override
    public ItemStack assemble(CraftingInventory inv) {
        if (this.func_77571_b().func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = this.func_77571_b().func_77946_l();
        ArrayList<ItemStack> nbtInputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77942_o()) continue;
            nbtInputs.add(stack);
        }
        if (nbtInputs.isEmpty()) {
            return toReturn;
        }
        Set<RecipeUpgradeType> supportedTypes = RecipeUpgradeData.getSupportedTypes(toReturn);
        if (supportedTypes.isEmpty()) {
            return toReturn;
        }
        EnumMap<RecipeUpgradeType, List> upgradeInfo = new EnumMap<RecipeUpgradeType, List>(RecipeUpgradeType.class);
        for (ItemStack itemStack : nbtInputs) {
            Set<RecipeUpgradeType> stackSupportedTypes = RecipeUpgradeData.getSupportedTypes(itemStack);
            for (RecipeUpgradeType supportedType : stackSupportedTypes) {
                RecipeUpgradeData<?> data;
                if (!supportedTypes.contains((Object)supportedType) || (data = RecipeUpgradeData.getUpgradeData(supportedType, itemStack)) == null) continue;
                upgradeInfo.computeIfAbsent(supportedType, type -> new ArrayList()).add(data);
            }
        }
        for (Map.Entry entry : upgradeInfo.entrySet()) {
            Object data;
            List upgradeData = (List)entry.getValue();
            if (upgradeData.isEmpty() || (data = RecipeUpgradeData.mergeUpgradeData(upgradeData)) != null && data.applyToStack(toReturn)) continue;
            return ItemStack.field_190927_a;
        }
        return toReturn;
    }
}

