/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ItemStackChemicalToItemStackRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;

    protected ItemStackChemicalToItemStackRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    protected String getChemicalInputJsonKey() {
        return "chemicalInput";
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        String chemicalInputKey = this.getChemicalInputJsonKey();
        JsonArray chemicalInput = JSONUtils.func_151202_d((JsonObject)json, (String)chemicalInputKey) ? JSONUtils.func_151214_t((JsonObject)json, (String)chemicalInputKey) : JSONUtils.func_152754_s((JsonObject)json, (String)chemicalInputKey);
        INGREDIENT chemicalIngredient = this.getDeserializer().deserialize((JsonElement)chemicalInput);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        if (output.func_190926_b()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, chemicalIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient itemInput = ItemStackIngredient.read(buffer);
            INGREDIENT chemicalInput = this.getDeserializer().read(buffer);
            ItemStack output = buffer.func_150791_c();
            return this.factory.create(recipeId, itemInput, chemicalInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack chemical to itemstack recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((ItemStackChemicalToItemStackRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack chemical to itemstack recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, INGREDIENT var3, ItemStack var4);
    }
}

