/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ChemicalChemicalToChemicalRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;

    protected ChemicalChemicalToChemicalRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    protected abstract STACK fromJson(@Nonnull JsonObject var1, @Nonnull String var2);

    protected abstract STACK fromBuffer(@Nonnull PacketBuffer var1);

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray leftIngredients = JSONUtils.func_151202_d((JsonObject)json, (String)"leftInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"leftInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"leftInput");
        INGREDIENT leftInput = this.getDeserializer().deserialize((JsonElement)leftIngredients);
        JsonArray rightIngredients = JSONUtils.func_151202_d((JsonObject)json, (String)"rightInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"rightInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"rightInput");
        INGREDIENT rightInput = this.getDeserializer().deserialize((JsonElement)rightIngredients);
        STACK output = this.fromJson(json, "output");
        if (((ChemicalStack)output).isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, leftInput, rightInput, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            INGREDIENT leftInput = this.getDeserializer().read(buffer);
            INGREDIENT rightInput = this.getDeserializer().read(buffer);
            STACK output = this.fromBuffer(buffer);
            return this.factory.create(recipeId, leftInput, rightInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading chemical chemical to chemical recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((ChemicalChemicalToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing chemical chemical to chemical recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(ResourceLocation var1, INGREDIENT var2, INGREDIENT var3, STACK var4);
    }
}

