/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.Mekanism;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@MethodsReturnNonnullByDefault
public class IngredientWithout
extends Ingredient {
    public static final ResourceLocation ID = Mekanism.rl("without");
    private final ItemListWithout itemListWithout;

    public static IngredientWithout create(ITag<Item> base, IItemProvider without) {
        return new IngredientWithout(Ingredient.func_199805_a(base), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{without}));
    }

    public static IngredientWithout create(ITag<Item> base, ITag<Item> without) {
        return new IngredientWithout(Ingredient.func_199805_a(base), Ingredient.func_199805_a(without));
    }

    private IngredientWithout(Ingredient base, Ingredient without) {
        this(new ItemListWithout(base, without));
    }

    private IngredientWithout(ItemListWithout itemListWithout) {
        super(Stream.of(itemListWithout));
        this.itemListWithout = itemListWithout;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return this.itemListWithout.base.test(stack) && !this.itemListWithout.without.test(stack);
    }

    public boolean func_203189_d() {
        return this.func_193365_a().length == 0;
    }

    public boolean isSimple() {
        return this.itemListWithout.base.isSimple() && this.itemListWithout.without.isSimple();
    }

    public IIngredientSerializer<IngredientWithout> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<IngredientWithout> {
        public static final IIngredientSerializer<IngredientWithout> INSTANCE = new Serializer();

        private Serializer() {
        }

        public IngredientWithout parse(@Nonnull JsonObject json) {
            if (json.has("base") && json.has("without")) {
                return new IngredientWithout(Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("base")), Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("without")));
            }
            throw new JsonParseException("A without ingredient must have both a base ingredient, and a negation ingredient.");
        }

        public IngredientWithout parse(@Nonnull PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient without = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new IngredientWithout(base, without);
        }

        public void write(@Nonnull PacketBuffer buffer, IngredientWithout ingredient) {
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.itemListWithout.base);
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.itemListWithout.without);
        }
    }

    private static class ItemListWithout
    implements Ingredient.IItemList {
        private final Ingredient base;
        private final Ingredient without;

        public ItemListWithout(Ingredient base, Ingredient without) {
            this.base = base;
            this.without = without;
        }

        public Collection<ItemStack> func_199799_a() {
            return Arrays.stream(this.base.func_193365_a()).filter(stack -> !this.without.test(stack)).collect(Collectors.toList());
        }

        public JsonObject func_200303_b() {
            JsonObject json = new JsonObject();
            json.addProperty("type", ID.toString());
            json.add("base", this.base.func_200304_c());
            json.add("without", this.without.func_200304_c());
            return json;
        }
    }
}

