/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.condition;

import com.google.gson.JsonObject;
import mekanism.common.Mekanism;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ModVersionLoadedCondition
implements ICondition {
    private static final ResourceLocation NAME = Mekanism.rl("mod_version_loaded");
    private final String minVersion;
    private final String modid;

    public ModVersionLoadedCondition(String modid, String version) {
        this.modid = modid;
        this.minVersion = version;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return ModList.get().getModContainerById(this.modid).filter(modContainer -> new ComparableVersion(this.minVersion).compareTo(new ComparableVersion(modContainer.getModInfo().getVersion().toString())) <= 0).isPresent();
    }

    public String toString() {
        return "mod_version_loaded(\"" + this.modid + "\", \"" + this.minVersion + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ModVersionLoadedCondition> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void write(JsonObject json, ModVersionLoadedCondition value) {
            json.addProperty("modid", value.modid);
            json.addProperty("minVersion", value.minVersion);
        }

        public ModVersionLoadedCondition read(JsonObject json) {
            return new ModVersionLoadedCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"modid"), JSONUtils.func_151200_h((JsonObject)json, (String)"minVersion"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

