/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiSetFrequency<FREQ extends Frequency>
implements IMekanismPacket {
    private final FrequencyType<FREQ> type;
    private final FrequencyUpdate updateType;
    private final Frequency.FrequencyIdentity data;
    private final BlockPos tilePosition;
    private final Hand currentHand;

    private PacketGuiSetFrequency(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition, Hand currentHand) {
        this.updateType = updateType;
        this.type = type;
        this.data = data;
        this.tilePosition = tilePosition;
        this.currentHand = currentHand;
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, tilePosition, null);
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, Hand currentHand) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, null, currentHand);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.updateType.isTile()) {
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, this.tilePosition);
            if (SecurityUtils.canAccess((PlayerEntity)player, tile) && tile instanceof IFrequencyHandler) {
                if (this.updateType == FrequencyUpdate.SET_TILE) {
                    ((IFrequencyHandler)tile).setFrequency(this.type, this.data, player.func_110124_au());
                } else if (this.updateType == FrequencyUpdate.REMOVE_TILE) {
                    ((IFrequencyHandler)tile).removeFrequency(this.type, this.data, player.func_110124_au());
                }
            }
        } else {
            ItemStack stack = player.func_184586_b(this.currentHand);
            if (SecurityUtils.canAccess((PlayerEntity)player, stack) && stack.func_77973_b() instanceof IFrequencyItem) {
                Frequency.FrequencyIdentity current;
                IFrequencyItem item = (IFrequencyItem)stack.func_77973_b();
                FrequencyManager<FREQ> manager = this.type.getManager(this.data, player.func_110124_au());
                if (this.updateType == FrequencyUpdate.SET_ITEM) {
                    item.setFrequency(stack, (Frequency)manager.getOrCreateFrequency(this.data, player.func_110124_au()));
                } else if (this.updateType == FrequencyUpdate.REMOVE_ITEM && manager.remove(this.data.getKey(), player.func_110124_au()) && (current = item.getFrequencyIdentity(stack)) != null && current.equals(this.data)) {
                    item.setFrequency(stack, null);
                }
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.updateType);
        this.type.write(buffer);
        this.type.getIdentitySerializer().write(buffer, this.data);
        if (this.updateType.isTile()) {
            buffer.func_179255_a(this.tilePosition);
        } else {
            buffer.func_179249_a((Enum)this.currentHand);
        }
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> decode(PacketBuffer buffer) {
        FrequencyUpdate updateType = (FrequencyUpdate)buffer.func_179257_a(FrequencyUpdate.class);
        FrequencyType type = FrequencyType.load(buffer);
        Frequency.FrequencyIdentity data = type.getIdentitySerializer().read(buffer);
        BlockPos pos = updateType.isTile() ? buffer.func_179259_c() : null;
        Hand hand = updateType.isTile() ? null : (Hand)buffer.func_179257_a(Hand.class);
        return new PacketGuiSetFrequency(updateType, type, data, pos, hand);
    }

    public static enum FrequencyUpdate {
        SET_TILE,
        SET_ITEM,
        REMOVE_TILE,
        REMOVE_ITEM;


        boolean isTile() {
            return this == SET_TILE || this == REMOVE_TILE;
        }
    }
}

