/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.collection.HashList;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketEditFilter
implements IMekanismPacket {
    private final IFilter<?> filter;
    private final IFilter<?> edited;
    private final boolean delete;
    private final BlockPos pos;

    public PacketEditFilter(BlockPos pos, boolean deletion, IFilter<?> filter, IFilter<?> edited) {
        this.pos = pos;
        this.delete = deletion;
        this.filter = filter;
        this.edited = edited;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, this.pos);
        if (tile != null) {
            HashList<QIOFilter<?>> filters;
            int index;
            if (this.filter instanceof SorterFilter && tile instanceof TileEntityLogisticalSorter) {
                HashList<SorterFilter<?>> filters2 = ((TileEntityLogisticalSorter)tile).getFilters();
                int index2 = filters2.indexOf(this.filter);
                if (index2 != -1) {
                    filters2.remove(index2);
                    if (!this.delete) {
                        filters2.add(index2, (SorterFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof MinerFilter && tile instanceof TileEntityDigitalMiner) {
                HashList<MinerFilter<?>> filters3 = ((TileEntityDigitalMiner)tile).getFilters();
                int index3 = filters3.indexOf(this.filter);
                if (index3 != -1) {
                    filters3.remove(index3);
                    if (!this.delete) {
                        filters3.add(index3, (MinerFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof OredictionificatorItemFilter && tile instanceof TileEntityOredictionificator) {
                HashList<OredictionificatorItemFilter> filters4 = ((TileEntityOredictionificator)tile).getFilters();
                int index4 = filters4.indexOf(this.filter);
                if (index4 != -1) {
                    filters4.remove(index4);
                    if (!this.delete) {
                        filters4.add(index4, (OredictionificatorItemFilter)this.edited);
                    }
                }
            } else if (this.filter instanceof QIOFilter && tile instanceof TileEntityQIOFilterHandler && (index = (filters = ((TileEntityQIOFilterHandler)tile).getFilters()).indexOf(this.filter)) != -1) {
                filters.remove(index);
                if (!this.delete) {
                    filters.add(index, (QIOFilter)this.edited);
                }
            }
            tile.func_70296_d();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.delete);
        this.filter.write(buffer);
        if (!this.delete) {
            this.edited.write(buffer);
        }
    }

    public static PacketEditFilter decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        boolean delete = buffer.readBoolean();
        IFilter<?> filter = BaseFilter.readFromPacket(buffer);
        IFilter<?> edited = null;
        if (!delete) {
            edited = BaseFilter.readFromPacket(buffer);
        }
        return new PacketEditFilter(pos, delete, filter, edited);
    }
}

