/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mekanism.client.MekanismClient;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSecurityUpdate
implements IMekanismPacket {
    private final boolean isUpdate;
    private SecurityData securityData;
    private String playerUsername;
    private UUID playerUUID;
    private Map<UUID, SecurityData> securityMap = new Object2ObjectOpenHashMap();
    private Map<UUID, String> uuidMap = new Object2ObjectOpenHashMap();

    public PacketSecurityUpdate(UUID uuid, SecurityData data) {
        this(true);
        this.playerUUID = uuid;
        this.playerUsername = MekanismUtils.getLastKnownUsername(uuid);
        this.securityData = data;
    }

    public PacketSecurityUpdate() {
        this(false);
    }

    private PacketSecurityUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.isUpdate) {
            MekanismClient.clientUUIDMap.put(this.playerUUID, this.playerUsername);
            if (this.securityData != null) {
                MekanismClient.clientSecurityMap.put(this.playerUUID, this.securityData);
            }
        } else {
            MekanismClient.clientSecurityMap.clear();
            MekanismClient.clientSecurityMap.putAll(this.securityMap);
            MekanismClient.clientUUIDMap.putAll(this.uuidMap);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.isUpdate);
        if (this.isUpdate) {
            buffer.func_179252_a(this.playerUUID);
            buffer.func_180714_a(this.playerUsername);
            if (this.securityData == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                this.securityData.write(buffer);
            }
        } else {
            ArrayList<SecurityFrequency> frequencies = new ArrayList<SecurityFrequency>(FrequencyType.SECURITY.getManager(null).getFrequencies());
            frequencies.removeIf(frequency -> frequency.getOwner() == null);
            buffer.func_150787_b(frequencies.size());
            for (SecurityFrequency frequency2 : frequencies) {
                UUID owner = frequency2.getOwner();
                buffer.func_179252_a(owner);
                new SecurityData(frequency2).write(buffer);
                buffer.func_180714_a(MekanismUtils.getLastKnownUsername(owner));
            }
        }
    }

    public static PacketSecurityUpdate decode(PacketBuffer buffer) {
        PacketSecurityUpdate packet = new PacketSecurityUpdate(buffer.readBoolean());
        if (packet.isUpdate) {
            packet.playerUUID = buffer.func_179253_g();
            packet.playerUsername = BasePacketHandler.readString(buffer);
            if (buffer.readBoolean()) {
                packet.securityData = SecurityData.read(buffer);
            }
        } else {
            int frequencySize = buffer.func_150792_a();
            packet.securityMap = new Object2ObjectOpenHashMap(frequencySize);
            packet.uuidMap = new Object2ObjectOpenHashMap(frequencySize);
            for (int i = 0; i < frequencySize; ++i) {
                UUID uuid = buffer.func_179253_g();
                packet.securityMap.put(uuid, SecurityData.read(buffer));
                packet.uuidMap.put(uuid, BasePacketHandler.readString(buffer));
            }
        }
        return packet;
    }
}

