/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.math.voxel.IShape;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.prefab.TileEntityInternalMultiblock;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultiblockData
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    public Set<BlockPos> locations = new ObjectOpenHashSet();
    public final Set<BlockPos> internalLocations = new ObjectOpenHashSet();
    public Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    public Set<BlockPos> innerNodes = new ObjectOpenHashSet();
    @ContainerSync(getter="getVolume", setter="setVolume")
    private int volume;
    public UUID inventoryID;
    public boolean hasMaster;
    @Nullable
    public BlockPos renderLocation;
    @ContainerSync
    private VoxelCuboid bounds = new VoxelCuboid(0, 0, 0);
    @ContainerSync
    private boolean formed;
    private int currentRedstoneLevel;
    private final BooleanSupplier remoteSupplier;
    private final Supplier<World> worldSupplier;
    protected final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    protected final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    protected final List<IGasTank> gasTanks = new ArrayList<IGasTank>();
    protected final List<IInfusionTank> infusionTanks = new ArrayList<IInfusionTank>();
    protected final List<IPigmentTank> pigmentTanks = new ArrayList<IPigmentTank>();
    protected final List<ISlurryTank> slurryTanks = new ArrayList<ISlurryTank>();
    protected final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    protected final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();
    private boolean dirty;

    public MultiblockData(TileEntity tile) {
        this.remoteSupplier = () -> tile.func_145831_w().func_201670_d();
        this.worldSupplier = () -> ((TileEntity)tile).func_145831_w();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean tick(World world) {
        boolean needsPacket = false;
        for (IValveHandler.ValveData data : this.valves) {
            data.activeTicks = Math.max(0, data.activeTicks - 1);
            if (data.activeTicks > 0 != data.prevActive) {
                needsPacket = true;
            }
            data.prevActive = data.activeTicks > 0;
        }
        return needsPacket;
    }

    protected double calculateAverageAmbientTemperature(World world) {
        BlockPos min = this.getMinPos();
        BlockPos max = this.getMaxPos();
        return HeatAPI.getAmbientTemp(MultiblockData.getBiomeTemp(world, min, new BlockPos(max.func_177958_n(), min.func_177956_o(), min.func_177952_p()), new BlockPos(min.func_177958_n(), min.func_177956_o(), max.func_177952_p()), new BlockPos(max.func_177958_n(), min.func_177956_o(), max.func_177952_p()), new BlockPos(min.func_177958_n(), max.func_177956_o(), min.func_177952_p()), new BlockPos(max.func_177958_n(), max.func_177956_o(), min.func_177952_p()), new BlockPos(min.func_177958_n(), max.func_177956_o(), max.func_177952_p()), max));
    }

    private static double getBiomeTemp(World world, BlockPos ... positions) {
        if (positions.length == 0) {
            throw new IllegalArgumentException("No positions given.");
        }
        return Arrays.stream(positions).mapToDouble(pos -> world.func_226691_t_(pos).func_225486_c(pos)).sum() / (double)positions.length;
    }

    public boolean setShape(IShape shape) {
        if (shape instanceof VoxelCuboid) {
            VoxelCuboid cuboid;
            this.bounds = cuboid = (VoxelCuboid)shape;
            this.renderLocation = cuboid.getMinPos().func_177972_a(Direction.UP);
            this.setVolume(this.bounds.length() * this.bounds.width() * this.bounds.height());
            return true;
        }
        return false;
    }

    public void onCreated(World world) {
        for (BlockPos blockPos : this.internalLocations) {
            TileEntityInternalMultiblock tile = WorldUtils.getTileEntity(TileEntityInternalMultiblock.class, (IBlockReader)world, blockPos);
            if (tile == null) continue;
            tile.setMultiblock(this.inventoryID);
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.FLUID)) {
            for (IExtendedFluidTank iExtendedFluidTank : this.getFluidTanks(null)) {
                iExtendedFluidTank.setStackSize(Math.min(iExtendedFluidTank.getFluidAmount(), iExtendedFluidTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.GAS)) {
            for (IGasTank iGasTank : this.getGasTanks(null)) {
                iGasTank.setStackSize(Math.min(iGasTank.getStored(), iGasTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.INFUSION)) {
            for (IInfusionTank iInfusionTank : this.getInfusionTanks(null)) {
                iInfusionTank.setStackSize(Math.min(iInfusionTank.getStored(), iInfusionTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.PIGMENT)) {
            for (IPigmentTank iPigmentTank : this.getPigmentTanks(null)) {
                iPigmentTank.setStackSize(Math.min(iPigmentTank.getStored(), iPigmentTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.SLURRY)) {
            for (ISlurryTank iSlurryTank : this.getSlurryTanks(null)) {
                iSlurryTank.setStackSize(Math.min(iSlurryTank.getStored(), iSlurryTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.ENERGY)) {
            for (IEnergyContainer iEnergyContainer : this.getEnergyContainers(null)) {
                iEnergyContainer.setEnergy(iEnergyContainer.getEnergy().min(iEnergyContainer.getMaxEnergy()));
            }
        }
        this.forceUpdateComparatorLevel();
    }

    protected boolean isRemote() {
        return this.remoteSupplier.getAsBoolean();
    }

    protected World getWorld() {
        return this.worldSupplier.get();
    }

    protected boolean shouldCap(MultiblockCache.CacheSubstance<?, ?> type) {
        return true;
    }

    public void remove(World world) {
        for (BlockPos pos : this.internalLocations) {
            TileEntityInternalMultiblock tile = WorldUtils.getTileEntity(TileEntityInternalMultiblock.class, (IBlockReader)world, pos);
            if (tile == null) continue;
            tile.setMultiblock(null);
        }
        this.inventoryID = null;
        this.formed = false;
    }

    public void readUpdateTag(CompoundNBT tag) {
        NBTUtils.setIntIfPresent(tag, "volume", this::setVolume);
        NBTUtils.setBlockPosIfPresent(tag, "renderLocation", value -> {
            this.renderLocation = value;
        });
        this.bounds = new VoxelCuboid(NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("min")), NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("max")));
        NBTUtils.setUUIDIfPresentElse(tag, "inventoryID", value -> {
            this.inventoryID = value;
        }, () -> {
            this.inventoryID = null;
        });
    }

    public void writeUpdateTag(CompoundNBT tag) {
        tag.func_74768_a("volume", this.getVolume());
        if (this.renderLocation != null) {
            tag.func_218657_a("renderLocation", (INBT)NBTUtil.func_186859_a((BlockPos)this.renderLocation));
        }
        tag.func_218657_a("min", (INBT)NBTUtil.func_186859_a((BlockPos)this.bounds.getMinPos()));
        tag.func_218657_a("max", (INBT)NBTUtil.func_186859_a((BlockPos)this.bounds.getMaxPos()));
        if (this.inventoryID != null) {
            tag.func_186854_a("inventoryID", this.inventoryID);
        }
    }

    @ComputerMethod(nameOverride="getLength")
    public int length() {
        return this.bounds.length();
    }

    @ComputerMethod(nameOverride="getWidth")
    public int width() {
        return this.bounds.width();
    }

    @ComputerMethod(nameOverride="getHeight")
    public int height() {
        return this.bounds.height();
    }

    @ComputerMethod
    public BlockPos getMinPos() {
        return this.bounds.getMinPos();
    }

    @ComputerMethod
    public BlockPos getMaxPos() {
        return this.bounds.getMaxPos();
    }

    public VoxelCuboid getBounds() {
        return this.bounds;
    }

    public <T extends MultiblockData> boolean isPositionInsideBounds(@Nonnull Structure structure, @Nonnull BlockPos pos) {
        if (this.isFormed()) {
            IStructureValidator<?> validator;
            MultiblockManager<?> manager;
            VoxelCuboid.CuboidRelative relativeLocation = this.getBounds().getRelativeLocation(pos);
            if (relativeLocation == VoxelCuboid.CuboidRelative.INSIDE) {
                return true;
            }
            if (relativeLocation.isWall() && (manager = structure.getManager()) != null && (validator = manager.createValidator()) instanceof CuboidStructureValidator) {
                CuboidStructureValidator cuboidValidator = (CuboidStructureValidator)validator;
                validator.init(this.getWorld(), manager, structure);
                cuboidValidator.loadCuboid(this.getBounds());
                return cuboidValidator.getStructureRequirement(pos) == FormationProtocol.StructureRequirement.INNER;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.isFormed() ? this.inventorySlots : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.isFormed() ? this.fluidTanks : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.isFormed() ? this.gasTanks : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.isFormed() ? this.infusionTanks : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.isFormed() ? this.pigmentTanks : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.isFormed() ? this.slurryTanks : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.isFormed() ? this.energyContainers : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.isFormed() ? this.heatCapacitors : Collections.emptyList();
    }

    public Set<Direction> getDirectionsToEmit(BlockPos pos) {
        EnumSet<Direction> directionsToEmit = EnumSet.noneOf(Direction.class);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            BlockPos neighborPos = pos.func_177972_a(direction);
            if (this.locations.contains(neighborPos) || this.internalLocations.contains(neighborPos)) continue;
            directionsToEmit.add(direction);
        }
        return directionsToEmit;
    }

    public Collection<IValveHandler.ValveData> getValveData() {
        return this.valves;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.locations.hashCode();
        code = 31 * code + this.bounds.hashCode();
        code = 31 * code + this.getVolume();
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MultiblockData data = (MultiblockData)obj;
        if (!data.locations.equals(this.locations)) {
            return false;
        }
        if (!data.bounds.equals(this.bounds)) {
            return false;
        }
        return data.getVolume() == this.getVolume();
    }

    public boolean isFormed() {
        return this.formed;
    }

    public void setFormedForce(boolean formed) {
        this.formed = formed;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void markDirtyComparator(World world) {
        if (!this.isFormed()) {
            return;
        }
        int newRedstoneLevel = this.getMultiblockRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.currentRedstoneLevel = newRedstoneLevel;
            this.notifyAllUpdateComparator(world);
        }
    }

    public void notifyAllUpdateComparator(World world) {
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityMultiblock tile = WorldUtils.getTileEntity(TileEntityMultiblock.class, (IBlockReader)world, valve.location);
            if (tile == null) continue;
            tile.markDirtyComparator();
        }
    }

    public void forceUpdateComparatorLevel() {
        this.currentRedstoneLevel = this.getMultiblockRedstoneLevel();
    }

    protected int getMultiblockRedstoneLevel() {
        return 0;
    }

    public int getCurrentRedstoneLevel() {
        return this.currentRedstoneLevel;
    }
}

