/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Contract;

public class ItemConfigurationCard
extends Item {
    public ItemConfigurationCard(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add((ITextComponent)MekanismLang.CONFIG_CARD_HAS_DATA.translateColored(EnumColor.GRAY, EnumColor.INDIGO, this.getConfigCardName(this.getData(stack))));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
        Optional configCardSupport = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIG_CARD_CAPABILITY, side).resolve();
        if (configCardSupport.isPresent()) {
            if (SecurityUtils.canAccess(player, tile)) {
                ItemStack stack = context.func_195996_i();
                if (player.func_225608_bj_()) {
                    if (!world.field_72995_K) {
                        IConfigCardAccess configCardAccess = (IConfigCardAccess)configCardSupport.get();
                        String translationKey = configCardAccess.getConfigCardName();
                        CompoundNBT data = configCardAccess.getConfigurationData(player);
                        data.func_74778_a("dataName", translationKey);
                        data.func_74778_a("dataType", configCardAccess.getConfigurationDataType().getRegistryName().toString());
                        ItemDataUtils.setCompound(stack, "data", data);
                        player.func_145747_a(MekanismUtils.logFormat(MekanismLang.CONFIG_CARD_GOT.translate(EnumColor.INDIGO, TextComponentUtil.translate(translationKey, new Object[0]))), Util.field_240973_b_);
                    }
                } else {
                    CompoundNBT data = this.getData(stack);
                    TileEntityType<?> storedType = this.getStoredTileType(data);
                    if (storedType == null) {
                        return ActionResultType.PASS;
                    }
                    if (!world.field_72995_K) {
                        IConfigCardAccess configCardAccess = (IConfigCardAccess)configCardSupport.get();
                        if (configCardAccess.isConfigurationDataCompatible(storedType)) {
                            configCardAccess.setConfigurationData(player, data);
                            configCardAccess.configurationDataSet();
                            player.func_145747_a(MekanismUtils.logFormat(EnumColor.DARK_GREEN, MekanismLang.CONFIG_CARD_SET.translate(EnumColor.INDIGO, this.getConfigCardName(data))), Util.field_240973_b_);
                        } else {
                            player.func_145747_a(MekanismUtils.logFormat(EnumColor.RED, MekanismLang.CONFIG_CARD_UNEQUAL), Util.field_240973_b_);
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
            SecurityUtils.displayNoAccess(player);
        }
        return ActionResultType.PASS;
    }

    private CompoundNBT getData(ItemStack stack) {
        CompoundNBT data = ItemDataUtils.getCompound(stack, "data");
        return data.isEmpty() ? null : data;
    }

    @Nullable
    @Contract(value="null -> null")
    private TileEntityType<?> getStoredTileType(@Nullable CompoundNBT data) {
        if (data == null || !data.func_150297_b("dataType", 8)) {
            return null;
        }
        ResourceLocation tileRegistryName = ResourceLocation.func_208304_a((String)data.func_74779_i("dataType"));
        return tileRegistryName == null ? null : (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(tileRegistryName);
    }

    private ITextComponent getConfigCardName(@Nullable CompoundNBT data) {
        if (data == null || !data.func_150297_b("dataName", 8)) {
            return MekanismLang.NONE.translate(new Object[0]);
        }
        return TextComponentUtil.translate(data.func_74779_i("dataName"), new Object[0]);
    }

    public boolean hasData(ItemStack stack) {
        CompoundNBT data = this.getData(stack);
        return data != null && data.func_150297_b("dataName", 8);
    }
}

