/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.world.IBlockReader;

public class MekanismTileContainer<TILE extends TileEntityMekanism>
extends MekanismContainer {
    private VirtualInventoryContainerSlot upgradeSlot;
    private VirtualInventoryContainerSlot upgradeOutputSlot;
    @Nonnull
    protected final TILE tile;

    public MekanismTileContainer(ContainerTypeRegistryObject<?> type, int id, PlayerInventory inv, @Nonnull TILE tile) {
        super(type, id, inv);
        this.tile = tile;
        this.addContainerTrackers();
        this.addSlotsAndOpen();
    }

    protected void addContainerTrackers() {
        ((TileEntityMekanism)this.tile).addContainerTrackers(this);
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    public ISecurityObject getSecurityObject() {
        return this.getTileEntity();
    }

    @Override
    protected void openInventory(@Nonnull PlayerInventory inv) {
        super.openInventory(inv);
        ((TileEntityMekanism)this.tile).open(inv.field_70458_d);
    }

    @Override
    protected void closeInventory(@Nonnull PlayerEntity player) {
        super.closeInventory(player);
        ((TileEntityMekanism)this.tile).close(player);
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return ((TileEntityMekanism)this.tile).hasGui() && !this.tile.func_145837_r() && WorldUtils.isBlockLoaded((IBlockReader)this.tile.func_145831_w(), this.tile.func_174877_v());
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        if (this instanceof IEmptyContainer) {
            return;
        }
        if (((TileEntityMekanism)this.tile).supportsUpgrades()) {
            this.upgradeSlot = ((TileEntityMekanism)this.tile).getComponent().getUpgradeSlot().createContainerSlot();
            this.func_75146_a(this.upgradeSlot);
            this.upgradeOutputSlot = ((TileEntityMekanism)this.tile).getComponent().getUpgradeOutputSlot().createContainerSlot();
            this.func_75146_a(this.upgradeOutputSlot);
        }
        if (((TileEntityMekanism)this.tile).hasInventory()) {
            List<IInventorySlot> inventorySlots = ((TileEntityMekanism)this.tile).getInventorySlots(null);
            for (IInventorySlot inventorySlot : inventorySlots) {
                Slot containerSlot = inventorySlot.createContainerSlot();
                if (containerSlot == null) continue;
                this.func_75146_a(containerSlot);
            }
        }
    }

    @Nullable
    public VirtualInventoryContainerSlot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    @Nullable
    public VirtualInventoryContainerSlot getUpgradeOutputSlot() {
        return this.upgradeOutputSlot;
    }
}

