/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import javax.annotation.Nonnull;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.inventory.PortableQIODashboardInventory;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class PortableQIODashboardContainer
extends QIOItemViewerContainer {
    protected final Hand hand;
    protected final ItemStack stack;

    private PortableQIODashboardContainer(int id, PlayerInventory inv, Hand hand, ItemStack stack, boolean remote, IQIOCraftingWindowHolder craftingWindowHolder) {
        super(MekanismContainerTypes.PORTABLE_QIO_DASHBOARD, id, inv, remote, craftingWindowHolder);
        this.hand = hand;
        this.stack = stack;
        this.addSlotsAndOpen();
    }

    public PortableQIODashboardContainer(int id, PlayerInventory inv, Hand hand, ItemStack stack, boolean remote) {
        this(id, inv, hand, stack, remote, new PortableQIODashboardInventory(stack, inv));
    }

    public Hand getHand() {
        return this.hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public PortableQIODashboardContainer recreate() {
        PortableQIODashboardContainer container = new PortableQIODashboardContainer(this.field_75152_c, this.inv, this.hand, this.stack, true, this.craftingWindowHolder);
        this.sync(container);
        return container;
    }

    @Override
    protected HotBarSlot createHotBarSlot(@Nonnull PlayerInventory inv, int index, int x, int y) {
        if (index == inv.field_70461_c && this.hand == Hand.MAIN_HAND) {
            return new HotBarSlot((IInventory)inv, index, x, y){

                public boolean func_82869_a(@Nonnull PlayerEntity player) {
                    return false;
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, @Nonnull ClickType clickType, @Nonnull PlayerEntity player) {
        if (clickType == ClickType.SWAP) {
            if (this.hand == Hand.OFF_HAND && dragType == 40) {
                return ItemStack.field_190927_a;
            }
            if (this.hand == Hand.MAIN_HAND && dragType >= 0 && dragType < PlayerInventory.func_70451_h() && !((HotBarSlot)this.hotBarSlots.get(dragType)).func_82869_a(player)) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    @Override
    public ISecurityObject getSecurityObject() {
        return SecurityUtils.wrapSecurityItem(this.stack);
    }
}

