/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;

public class ChemicalElement
extends LookingAtElement {
    @Nonnull
    protected final ChemicalStack<?> stored;
    protected final long capacity;

    public ChemicalElement(@Nonnull ChemicalStack<?> stored, long capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0L || this.stored.getAmount() == Long.MAX_VALUE) {
            return level;
        }
        return MathUtils.clampToInt((double)level * (double)this.stored.getAmount() / (double)this.capacity);
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.stored.isEmpty() ? null : MekanismRenderer.getChemicalTexture(this.stored.getType());
    }

    @Override
    public ITextComponent getText() {
        long amount = this.stored.getAmount();
        if (amount == Long.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(this.stored.getType(), MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(this.stored.getType(), TextUtils.format(amount));
    }

    @Override
    protected boolean applyRenderColor() {
        MekanismRenderer.color(this.stored.getType());
        return true;
    }
}

