/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.CrushingIRecipe;
import mekanism.common.recipe.impl.EnrichingIRecipe;
import mekanism.common.recipe.impl.SmeltingIRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToItemStack")
public abstract class ItemStackToItemStackRecipeManager
extends MekanismRecipeManager<ItemStackToItemStackRecipe> {
    protected ItemStackToItemStackRecipeManager(MekanismRecipeType<ItemStackToItemStackRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, this.getAndValidateNotEmpty(output)));
    }

    protected abstract ItemStackToItemStackRecipe makeRecipe(ResourceLocation var1, ItemStackIngredient var2, ItemStack var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToItemStackRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ItemStackToItemStackRecipe)this.getRecipe()).getOutputDefinition(), ItemStackHelper::getCommandString);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToItemStack.Smelting")
    public static class EnergizedSmelterRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnergizedSmelterRecipeManager INSTANCE = new EnergizedSmelterRecipeManager();

        private EnergizedSmelterRecipeManager() {
            super(MekanismRecipeType.SMELTING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new SmeltingIRecipe(id, input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToItemStack.Enriching")
    public static class EnrichmentChamberRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnrichmentChamberRecipeManager INSTANCE = new EnrichmentChamberRecipeManager();

        private EnrichmentChamberRecipeManager() {
            super(MekanismRecipeType.ENRICHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new EnrichingIRecipe(id, input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToItemStack.Crushing")
    public static class CrusherRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final CrusherRecipeManager INSTANCE = new CrusherRecipeManager();

        private CrusherRecipeManager() {
            super(MekanismRecipeType.CRUSHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new CrushingIRecipe(id, input, output);
        }
    }
}

